/*
 * Decompiled with CFR 0.152.
 */
package com.alexbarter.ciphertool.base.key.types;

import com.alexbarter.ciphertool.base.key.IRangedKeyType;
import com.alexbarter.ciphertool.base.key.KeyGeneration;
import com.alexbarter.ciphertool.lib.matrix.Matrix;
import com.alexbarter.lib.util.RandomUtil;
import java.math.BigInteger;
import java.util.Optional;
import java.util.function.Function;

public class SquareMatrixKeyType
implements IRangedKeyType<Matrix> {
    private int mod;
    private int min;
    private int max;

    public SquareMatrixKeyType(int mod, int min, int max) {
        this.mod = mod;
        this.min = min;
        this.max = max;
    }

    @Override
    public Matrix randomise() {
        Matrix matrix;
        while (!(matrix = KeyGeneration.createMatrix(RandomUtil.pickRandomInt((int)this.min, (int)this.max), this.mod)).hasInverseMod(this.mod)) {
        }
        return matrix;
    }

    @Override
    public boolean iterateKeys(Function<Matrix, Boolean> consumer) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public Matrix alterKey(Matrix key) {
        return key;
    }

    @Override
    public boolean isValid(Matrix key) {
        return true;
    }

    @Override
    public String prettifyKey(Matrix key) {
        return key.toString();
    }

    @Override
    public BigInteger getNumOfKeys() {
        BigInteger total = BigInteger.ONE;
        return total;
    }

    @Override
    public int getMin() {
        return this.min;
    }

    @Override
    public int getMax() {
        return this.max;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    implements IRangedKeyType.IRangedKeyBuilder<Matrix> {
        private Optional<Integer> min = Optional.empty();
        private Optional<Integer> max = Optional.empty();
        private Optional<Integer> mod = Optional.empty();

        private Builder() {
        }

        public Builder setMin(int min) {
            this.min = Optional.of(min);
            return this;
        }

        public Builder setMax(int max) {
            this.max = Optional.of(max);
            return this;
        }

        public Builder setRange(int min, int max) {
            return this.setMin(min).setMax(max);
        }

        public Builder setSize(int size) {
            return this.setRange(size, size);
        }

        public Builder setMod(int mod) {
            this.mod = Optional.of(mod);
            return this;
        }

        public SquareMatrixKeyType create() {
            SquareMatrixKeyType handler = new SquareMatrixKeyType(this.mod.orElse(26), this.min.orElse(2), this.max.orElse(4));
            return handler;
        }
    }
}

