/*
 * Decompiled with CFR 0.152.
 */
package com.alexbarter.ciphertool.base.format;

import com.alexbarter.ciphertool.base.format.BlockFormat;
import com.alexbarter.ciphertool.base.format.CaseFormat;
import com.alexbarter.ciphertool.base.format.IParseFormat;
import com.alexbarter.ciphertool.base.format.MaintainFormat;
import com.alexbarter.ciphertool.base.format.PadFormat;
import com.alexbarter.ciphertool.base.interfaces.IFormat;
import com.alexbarter.ciphertool.lib.registry.IRegistry;
import com.alexbarter.ciphertool.lib.registry.Registry;
import java.util.Locale;

public class Formats {
    public static IFormat BLOCK_5 = new BlockFormat(5);
    public static IRegistry<String, IFormat> FORMATS = Registry.builder(IFormat.class).addValidation((k, v) -> !k.contains(":")).build();
    public static IRegistry<String, IParseFormat> FORMAT_PARSE = Registry.builder(IParseFormat.class).addValidation((k, v) -> !k.contains(":")).build();

    public static void registryFormats() {
        FORMAT_PARSE.register((Object)"block", (Object)BlockFormat.PARSE);
        FORMAT_PARSE.register((Object)"case", (Object)CaseFormat.PARSE);
        FORMAT_PARSE.register((Object)"pad", (Object)PadFormat.PARSE);
        FORMAT_PARSE.register((Object)"maintain", (Object)MaintainFormat.PARSE);
        for (int i = 1; i < 20; ++i) {
            FORMATS.register((Object)("block_" + i), (Object)new BlockFormat(i));
        }
        for (CaseFormat.Type type : CaseFormat.Type.values()) {
            FORMATS.register((Object)("case_" + type.name().toLowerCase(Locale.UK)), (Object)new CaseFormat(type));
        }
        FORMATS.register((Object)"pad", (Object)new PadFormat(5, Character.valueOf('X')));
    }
}

