/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net.puretls;

import COM.claymoresystems.cert.X509Cert;
import COM.claymoresystems.ptls.SSLSocket;
import COM.claymoresystems.sslg.SSLPolicyInt;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tomcat.util.buf.HexUtils;
import org.apache.tomcat.util.net.SSLSupport;

class PureTLSSupport
implements SSLSupport {
    static Log logger = LogFactory.getLog((Class)(class$org$apache$tomcat$util$net$puretls$PureTLSSupport == null ? (class$org$apache$tomcat$util$net$puretls$PureTLSSupport = PureTLSSupport.class$("org.apache.tomcat.util.net.puretls.PureTLSSupport")) : class$org$apache$tomcat$util$net$puretls$PureTLSSupport));
    private SSLSocket ssl;
    static /* synthetic */ Class class$org$apache$tomcat$util$net$puretls$PureTLSSupport;

    PureTLSSupport(SSLSocket sock) {
        this.ssl = sock;
    }

    public String getCipherSuite() throws IOException {
        int cs = this.ssl.getCipherSuite();
        return SSLPolicyInt.getCipherSuiteName((int)cs);
    }

    public Object[] getPeerCertificateChain() throws IOException {
        return this.getPeerCertificateChain(false);
    }

    public Object[] getPeerCertificateChain(boolean force) throws IOException {
        Vector v = this.ssl.getCertificateChain();
        if (v == null && force) {
            SSLPolicyInt policy = new SSLPolicyInt();
            policy.requireClientAuth(true);
            policy.handshakeOnConnect(false);
            policy.waitOnClose(false);
            this.ssl.renegotiate(policy);
            v = this.ssl.getCertificateChain();
        }
        if (v == null) {
            return null;
        }
        Object[] chain = new X509Certificate[v.size()];
        try {
            for (int i = 1; i <= v.size(); ++i) {
                byte[] buffer = ((X509Cert)v.elementAt(v.size() - i)).getDER();
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                ByteArrayInputStream stream = new ByteArrayInputStream(buffer);
                X509Certificate xCert = (X509Certificate)cf.generateCertificate(stream);
                chain[i - 1] = xCert;
                if (!logger.isTraceEnabled()) continue;
                logger.trace((Object)("Cert # " + i + " = " + xCert));
            }
        }
        catch (CertificateException e) {
            logger.info((Object)"JDK's broken cert handling can't parse this certificate (which PureTLS likes)", (Throwable)e);
            throw new IOException("JDK's broken cert handling can't parse this certificate (which PureTLS likes)");
        }
        return chain;
    }

    public Integer getKeySize() throws IOException {
        int cs = this.ssl.getCipherSuite();
        String cipherSuite = SSLPolicyInt.getCipherSuiteName((int)cs);
        int size = 0;
        for (int i = 0; i < SSLSupport.ciphers.length; ++i) {
            if (cipherSuite.indexOf(SSLSupport.ciphers[i].phrase) < 0) continue;
            size = SSLSupport.ciphers[i].keySize;
            break;
        }
        Integer keySize = new Integer(size);
        return keySize;
    }

    public String getSessionId() throws IOException {
        byte[] ssl_session = this.ssl.getSessionID();
        if (ssl_session == null) {
            return null;
        }
        return HexUtils.convert(ssl_session);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

