/*
 * Decompiled with CFR 0.152.
 */
package tk.mybatis.mapper.mapperhelper;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.ParameterMode;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.apache.ibatis.scripting.xmltags.DynamicSqlSource;
import org.apache.ibatis.scripting.xmltags.SqlNode;
import org.apache.ibatis.scripting.xmltags.XMLLanguageDriver;
import tk.mybatis.mapper.MapperException;
import tk.mybatis.mapper.entity.EntityColumn;
import tk.mybatis.mapper.entity.EntityTable;
import tk.mybatis.mapper.mapperhelper.EntityHelper;
import tk.mybatis.mapper.mapperhelper.MapperHelper;
import tk.mybatis.mapper.util.MsUtil;
import tk.mybatis.mapper.util.StringUtil;

public abstract class MapperTemplate {
    private static final XMLLanguageDriver languageDriver = new XMLLanguageDriver();
    protected Map<String, Method> methodMap = new ConcurrentHashMap<String, Method>();
    protected Map<String, Class<?>> entityClassMap = new ConcurrentHashMap();
    protected Class<?> mapperClass;
    protected MapperHelper mapperHelper;

    public MapperTemplate(Class<?> mapperClass, MapperHelper mapperHelper) {
        this.mapperClass = mapperClass;
        this.mapperHelper = mapperHelper;
    }

    public String dynamicSQL(Object record) {
        return "dynamicSQL";
    }

    public void addMethodMap(String methodName, Method method) {
        this.methodMap.put(methodName, method);
    }

    public String getIDENTITY(EntityColumn column) {
        return MessageFormat.format(this.mapperHelper.getConfig().getIDENTITY(), column.getSequenceName(), column.getColumn(), column.getProperty(), column.getTable().getName());
    }

    public boolean supportMethod(String msId) {
        Class<?> mapperClass = MsUtil.getMapperClass(msId);
        if (mapperClass != null && this.mapperClass.isAssignableFrom(mapperClass)) {
            String methodName = MsUtil.getMethodName(msId);
            return this.methodMap.get(methodName) != null;
        }
        return false;
    }

    protected void setResultType(MappedStatement ms, Class<?> entityClass) {
        EntityTable entityTable = EntityHelper.getEntityTable(entityClass);
        ArrayList<ResultMap> resultMaps = new ArrayList<ResultMap>();
        resultMaps.add(entityTable.getResultMap(ms.getConfiguration()));
        MetaObject metaObject = SystemMetaObject.forObject((Object)ms);
        metaObject.setValue("resultMaps", Collections.unmodifiableList(resultMaps));
    }

    protected void setSqlSource(MappedStatement ms, SqlSource sqlSource) {
        MetaObject msObject = SystemMetaObject.forObject((Object)ms);
        msObject.setValue("sqlSource", (Object)sqlSource);
    }

    public SqlSource createSqlSource(MappedStatement ms, String xmlSql) {
        return languageDriver.createSqlSource(ms.getConfiguration(), "<script>\n\t" + xmlSql + "</script>", null);
    }

    public Class<?> getEntityClass(MappedStatement ms) {
        Type[] types;
        String msId = ms.getId();
        if (this.entityClassMap.containsKey(msId)) {
            return this.entityClassMap.get(msId);
        }
        Class<?> mapperClass = MsUtil.getMapperClass(msId);
        for (Type type : types = mapperClass.getGenericInterfaces()) {
            ParameterizedType t;
            if (!(type instanceof ParameterizedType) || (t = (ParameterizedType)type).getRawType() != this.mapperClass && !this.mapperClass.isAssignableFrom((Class)t.getRawType())) continue;
            Class returnType = (Class)t.getActualTypeArguments()[0];
            EntityHelper.initEntityNameMap(returnType, this.mapperHelper.getConfig());
            this.entityClassMap.put(msId, returnType);
            return returnType;
        }
        throw new MapperException("\u65e0\u6cd5\u83b7\u53d6 " + msId + " \u65b9\u6cd5\u7684\u6cdb\u578b\u4fe1\u606f!");
    }

    @Deprecated
    protected List<ParameterMapping> getPrimaryKeyParameterMappings(MappedStatement ms) {
        Class<?> entityClass = this.getEntityClass(ms);
        Set<EntityColumn> entityColumns = EntityHelper.getPKColumns(entityClass);
        ArrayList<ParameterMapping> parameterMappings = new ArrayList<ParameterMapping>();
        for (EntityColumn column : entityColumns) {
            ParameterMapping.Builder builder = new ParameterMapping.Builder(ms.getConfiguration(), column.getProperty(), column.getJavaType());
            builder.mode(ParameterMode.IN);
            parameterMappings.add(builder.build());
        }
        return parameterMappings;
    }

    protected String getSeqNextVal(EntityColumn column) {
        return MessageFormat.format(this.mapperHelper.getConfig().getSeqFormat(), column.getSequenceName(), column.getColumn(), column.getProperty(), column.getTable().getName());
    }

    protected String tableName(Class<?> entityClass) {
        EntityTable entityTable = EntityHelper.getEntityTable(entityClass);
        String prefix = entityTable.getPrefix();
        if (StringUtil.isEmpty(prefix)) {
            prefix = this.mapperHelper.getConfig().getPrefix();
        }
        if (StringUtil.isNotEmpty(prefix)) {
            return prefix + "." + entityTable.getName();
        }
        return entityTable.getName();
    }

    public String getIDENTITY() {
        return this.mapperHelper.getConfig().getIDENTITY();
    }

    public String getUUID() {
        return this.mapperHelper.getConfig().getUUID();
    }

    public boolean isBEFORE() {
        return this.mapperHelper.getConfig().isBEFORE();
    }

    public boolean isCheckExampleEntityClass() {
        return this.mapperHelper.getConfig().isCheckExampleEntityClass();
    }

    public boolean isNotEmpty() {
        return this.mapperHelper.getConfig().isNotEmpty();
    }

    public void setSqlSource(MappedStatement ms) throws Exception {
        block7: {
            if (this.mapperClass == MsUtil.getMapperClass(ms.getId())) {
                throw new MapperException("\u8bf7\u4e0d\u8981\u914d\u7f6e\u6216\u626b\u63cf\u901a\u7528Mapper\u63a5\u53e3\u7c7b\uff1a" + this.mapperClass);
            }
            Method method = this.methodMap.get(MsUtil.getMethodName(ms));
            try {
                if (method.getReturnType() == Void.TYPE) {
                    method.invoke((Object)this, ms);
                    break block7;
                }
                if (SqlNode.class.isAssignableFrom(method.getReturnType())) {
                    SqlNode sqlNode = (SqlNode)method.invoke((Object)this, ms);
                    DynamicSqlSource dynamicSqlSource = new DynamicSqlSource(ms.getConfiguration(), sqlNode);
                    this.setSqlSource(ms, (SqlSource)dynamicSqlSource);
                    break block7;
                }
                if (String.class.equals(method.getReturnType())) {
                    String xmlSql = (String)method.invoke((Object)this, ms);
                    SqlSource sqlSource = this.createSqlSource(ms, xmlSql);
                    this.setSqlSource(ms, sqlSource);
                    break block7;
                }
                throw new MapperException("\u81ea\u5b9a\u4e49Mapper\u65b9\u6cd5\u8fd4\u56de\u7c7b\u578b\u9519\u8bef,\u53ef\u9009\u7684\u8fd4\u56de\u7c7b\u578b\u4e3avoid,SqlNode,String\u4e09\u79cd!");
            }
            catch (IllegalAccessException e) {
                throw new MapperException(e);
            }
            catch (InvocationTargetException e) {
                throw new MapperException(e.getTargetException() != null ? e.getTargetException() : e);
            }
        }
    }
}

