/*
 * Decompiled with CFR 0.152.
 */
package tk.mybatis.mapper.entity;

import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.TypeHandler;
import tk.mybatis.mapper.entity.EntityTable;
import tk.mybatis.mapper.util.StringUtil;

public class EntityColumn {
    private EntityTable table;
    private String property;
    private String column;
    private Class<?> javaType;
    private JdbcType jdbcType;
    private Class<? extends TypeHandler<?>> typeHandler;
    private String sequenceName;
    private boolean id = false;
    private boolean uuid = false;
    private boolean identity = false;
    private String generator;
    private String orderBy;
    private boolean insertable = true;
    private boolean updatable = true;

    public EntityColumn() {
    }

    public EntityColumn(EntityTable table) {
        this.table = table;
    }

    public String getColumnEqualsHolder(String entityName) {
        return this.column + " = " + this.getColumnHolder(entityName);
    }

    public String getColumnHolder(String entityName) {
        return this.getColumnHolder(entityName, null);
    }

    public String getColumnHolder(String entityName, String suffix) {
        return this.getColumnHolder(entityName, null, null);
    }

    public String getColumnHolderWithComma(String entityName, String suffix) {
        return this.getColumnHolder(entityName, suffix, ",");
    }

    public String getColumnHolder(String entityName, String suffix, String separator) {
        StringBuffer sb = new StringBuffer("#{");
        if (StringUtil.isNotEmpty(entityName)) {
            sb.append(entityName);
            sb.append(".");
        }
        sb.append(this.property);
        if (StringUtil.isNotEmpty(suffix)) {
            sb.append(suffix);
        }
        if (this.jdbcType != null) {
            sb.append(",jdbcType=");
            sb.append(this.jdbcType.toString());
        } else if (this.typeHandler != null) {
            sb.append(",typeHandler=");
            sb.append(this.typeHandler.getCanonicalName());
        } else if (!this.javaType.isArray()) {
            sb.append(",javaType=");
            sb.append(this.javaType.getCanonicalName());
        }
        sb.append("}");
        if (StringUtil.isNotEmpty(separator)) {
            sb.append(separator);
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EntityColumn that = (EntityColumn)o;
        if (this.id != that.id) {
            return false;
        }
        if (this.uuid != that.uuid) {
            return false;
        }
        if (this.identity != that.identity) {
            return false;
        }
        if (this.table != null ? !this.table.equals(that.table) : that.table != null) {
            return false;
        }
        if (this.property != null ? !this.property.equals(that.property) : that.property != null) {
            return false;
        }
        if (this.column != null ? !this.column.equals(that.column) : that.column != null) {
            return false;
        }
        if (this.javaType != null ? !this.javaType.equals(that.javaType) : that.javaType != null) {
            return false;
        }
        if (this.jdbcType != that.jdbcType) {
            return false;
        }
        if (this.typeHandler != null ? !this.typeHandler.equals(that.typeHandler) : that.typeHandler != null) {
            return false;
        }
        if (this.sequenceName != null ? !this.sequenceName.equals(that.sequenceName) : that.sequenceName != null) {
            return false;
        }
        if (this.generator != null ? !this.generator.equals(that.generator) : that.generator != null) {
            return false;
        }
        return !(this.orderBy == null ? that.orderBy != null : !this.orderBy.equals(that.orderBy));
    }

    public int hashCode() {
        int result = this.table != null ? this.table.hashCode() : 0;
        result = 31 * result + (this.property != null ? this.property.hashCode() : 0);
        result = 31 * result + (this.column != null ? this.column.hashCode() : 0);
        result = 31 * result + (this.javaType != null ? this.javaType.hashCode() : 0);
        result = 31 * result + (this.jdbcType != null ? this.jdbcType.hashCode() : 0);
        result = 31 * result + (this.typeHandler != null ? this.typeHandler.hashCode() : 0);
        result = 31 * result + (this.sequenceName != null ? this.sequenceName.hashCode() : 0);
        result = 31 * result + (this.id ? 1 : 0);
        result = 31 * result + (this.uuid ? 1 : 0);
        result = 31 * result + (this.identity ? 1 : 0);
        result = 31 * result + (this.generator != null ? this.generator.hashCode() : 0);
        result = 31 * result + (this.orderBy != null ? this.orderBy.hashCode() : 0);
        return result;
    }

    public String getColumn() {
        return this.column;
    }

    public void setColumn(String column) {
        this.column = column;
    }

    public String getColumnEqualsHolder() {
        return this.getColumnEqualsHolder(null);
    }

    public String getColumnHolder() {
        return this.getColumnHolder(null);
    }

    public String getGenerator() {
        return this.generator;
    }

    public void setGenerator(String generator) {
        this.generator = generator;
    }

    public Class<?> getJavaType() {
        return this.javaType;
    }

    public void setJavaType(Class<?> javaType) {
        this.javaType = javaType;
    }

    public JdbcType getJdbcType() {
        return this.jdbcType;
    }

    public void setJdbcType(JdbcType jdbcType) {
        this.jdbcType = jdbcType;
    }

    public String getOrderBy() {
        return this.orderBy;
    }

    public void setOrderBy(String orderBy) {
        this.orderBy = orderBy;
    }

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public String getSequenceName() {
        return this.sequenceName;
    }

    public void setSequenceName(String sequenceName) {
        this.sequenceName = sequenceName;
    }

    public EntityTable getTable() {
        return this.table;
    }

    public void setTable(EntityTable table) {
        this.table = table;
    }

    public Class<? extends TypeHandler<?>> getTypeHandler() {
        return this.typeHandler;
    }

    public void setTypeHandler(Class<? extends TypeHandler<?>> typeHandler) {
        this.typeHandler = typeHandler;
    }

    public boolean isId() {
        return this.id;
    }

    public void setId(boolean id) {
        this.id = id;
    }

    public boolean isIdentity() {
        return this.identity;
    }

    public void setIdentity(boolean identity) {
        this.identity = identity;
    }

    public boolean isInsertable() {
        return this.insertable;
    }

    public void setInsertable(boolean insertable) {
        this.insertable = insertable;
    }

    public boolean isUpdatable() {
        return this.updatable;
    }

    public void setUpdatable(boolean updatable) {
        this.updatable = updatable;
    }

    public boolean isUuid() {
        return this.uuid;
    }

    public void setUuid(boolean uuid) {
        this.uuid = uuid;
    }
}

