/*
 * Decompiled with CFR 0.152.
 */
package tk.mybatis.spring.mapper;

import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.core.env.AbstractEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import tk.mybatis.mapper.mapperhelper.MapperHelper;
import tk.mybatis.mapper.util.StringUtil;
import tk.mybatis.spring.mapper.MapperFactoryBean;

public class ClassPathMapperScanner
extends org.mybatis.spring.mapper.ClassPathMapperScanner {
    public static final Pattern ARRAY_PATTERN = Pattern.compile("\\[\\d+\\]$");
    public static final String MAPPER_PREFIX = "mapper.";
    private MapperHelper mapperHelper = new MapperHelper();

    public ClassPathMapperScanner(BeanDefinitionRegistry registry) {
        super(registry);
    }

    public Set<BeanDefinitionHolder> doScan(String ... basePackages) {
        Set beanDefinitions = super.doScan(basePackages);
        this.doAfterScan(beanDefinitions);
        return beanDefinitions;
    }

    protected void doAfterScan(Set<BeanDefinitionHolder> beanDefinitions) {
        this.mapperHelper.ifEmptyRegisterDefaultInterface();
        for (BeanDefinitionHolder holder : beanDefinitions) {
            GenericBeanDefinition definition = (GenericBeanDefinition)holder.getBeanDefinition();
            if (!StringUtil.isNotEmpty((String)definition.getBeanClassName()) || !definition.getBeanClassName().equals("org.mybatis.spring.mapper.MapperFactoryBean")) continue;
            definition.setBeanClass(MapperFactoryBean.class);
            definition.getPropertyValues().add("mapperHelper", (Object)this.mapperHelper);
        }
    }

    public void setMapperProperties(Environment environment) {
        if (environment != null) {
            Properties properties = new Properties();
            MutablePropertySources propertySources = ((AbstractEnvironment)environment).getPropertySources();
            for (PropertySource propertySource : propertySources) {
                String[] propertyNames;
                if (!(propertySource instanceof EnumerablePropertySource)) continue;
                EnumerablePropertySource enumerablePropertySource = (EnumerablePropertySource)propertySource;
                for (String propertyName : propertyNames = enumerablePropertySource.getPropertyNames()) {
                    if (!propertyName.startsWith(MAPPER_PREFIX)) continue;
                    String propertyValue = environment.getProperty(propertyName);
                    Matcher matcher = ARRAY_PATTERN.matcher(propertyName);
                    if (matcher.find()) {
                        propertyName = matcher.replaceAll("");
                    }
                    if (properties.containsKey(propertyName)) {
                        propertyValue = properties.getProperty(propertyName) + "," + propertyValue;
                    }
                    properties.put(propertyName, propertyValue);
                }
            }
            this.mapperHelper.setProperties(properties);
        }
    }
}

