/*
 * Decompiled with CFR 0.152.
 */
package tk.mybatis.mapper.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import tk.mybatis.mapper.MapperException;
import tk.mybatis.mapper.util.StringUtil;

public class SimpleTypeUtil {
    public static final String[] JAVA8_DATE_TIME = new String[]{"java.time.Instant", "java.time.LocalDateTime", "java.time.LocalDate", "java.time.LocalTime", "java.time.OffsetDateTime", "java.time.OffsetTime", "java.time.ZonedDateTime", "java.time.Year", "java.time.Month", "java.time.YearMonth"};
    private static final Set<Class<?>> SIMPLE_TYPE_SET = new HashSet();

    public static void registerSimpleType(Class<?> clazz) {
        SIMPLE_TYPE_SET.add(clazz);
    }

    public static void registerPrimitiveTypes() {
        SimpleTypeUtil.registerSimpleType(Boolean.TYPE);
        SimpleTypeUtil.registerSimpleType(Byte.TYPE);
        SimpleTypeUtil.registerSimpleType(Short.TYPE);
        SimpleTypeUtil.registerSimpleType(Integer.TYPE);
        SimpleTypeUtil.registerSimpleType(Long.TYPE);
        SimpleTypeUtil.registerSimpleType(Character.TYPE);
        SimpleTypeUtil.registerSimpleType(Float.TYPE);
        SimpleTypeUtil.registerSimpleType(Double.TYPE);
    }

    public static void registerSimpleType(String classes) {
        if (StringUtil.isNotEmpty(classes)) {
            String[] cls;
            for (String c : cls = classes.split(",")) {
                try {
                    SIMPLE_TYPE_SET.add(Class.forName(c));
                }
                catch (ClassNotFoundException e) {
                    throw new MapperException("\u6ce8\u518c\u7c7b\u578b\u51fa\u9519:" + c, e);
                }
            }
        }
    }

    private static void registerSimpleTypeSilence(String clazz) {
        try {
            SIMPLE_TYPE_SET.add(Class.forName(clazz));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public static boolean isSimpleType(Class<?> clazz) {
        return SIMPLE_TYPE_SET.contains(clazz);
    }

    static {
        SIMPLE_TYPE_SET.add(byte[].class);
        SIMPLE_TYPE_SET.add(String.class);
        SIMPLE_TYPE_SET.add(Byte.class);
        SIMPLE_TYPE_SET.add(Short.class);
        SIMPLE_TYPE_SET.add(Character.class);
        SIMPLE_TYPE_SET.add(Integer.class);
        SIMPLE_TYPE_SET.add(Long.class);
        SIMPLE_TYPE_SET.add(Float.class);
        SIMPLE_TYPE_SET.add(Double.class);
        SIMPLE_TYPE_SET.add(Boolean.class);
        SIMPLE_TYPE_SET.add(Date.class);
        SIMPLE_TYPE_SET.add(Timestamp.class);
        SIMPLE_TYPE_SET.add(Class.class);
        SIMPLE_TYPE_SET.add(BigInteger.class);
        SIMPLE_TYPE_SET.add(BigDecimal.class);
        for (String time : JAVA8_DATE_TIME) {
            SimpleTypeUtil.registerSimpleTypeSilence(time);
        }
    }
}

