/*
 * Decompiled with CFR 0.152.
 */
package tk.jamunx.ui.browser.ui;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Point;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.JavascriptInterface;
import android.webkit.RenderProcessGoneDetail;
import android.webkit.SafeBrowsingResponse;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceRequest;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.PopupWindow;
import android.widget.ProgressBar;
import android.widget.TextView;
import android.widget.Toast;
import androidx.appcompat.app.AppCompatActivity;
import java.io.IOException;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.select.Elements;
import tk.jamunx.ui.browser.R;
import tk.jamunx.ui.browser.extras.Browser;
import tk.jamunx.ui.browser.extras.CheckOs;
import tk.jamunx.ui.browser.extras.HelperDialogCommon;
import tk.jamunx.ui.browser.extras.MySnackBar;
import tk.jamunx.ui.intent.views.PickerShareFiles;

public class SinglePageBrowser
extends AppCompatActivity {
    private static final String KEY_SUBJECT = "intentSubject";
    private static final String KEY_TOAST_COPIED = "intentToastCopied";
    private static final String KEY_URL = "intentUrl";
    private static final String KEY_TITLE = "intentTitle";
    private static final String KEY_DESC = "intentDesc";
    private static final String KEY_BOUND_HOST = "intentBoundHost";
    private WebView webView;
    private String url;
    private String currentUrl;
    private TextView textViewTitle;
    private TextView textViewSubTitle;
    private AsyncUrlParsing async;
    private PopupWindow changeStatusPopUp;
    private ProgressBar progressBar;
    private String shareDescription;
    private String shareSubject;
    private String toastMessageUrlCopied;
    private String copyToClipboardTitle;
    private boolean boundUrlToHost = true;
    private boolean disableJavascript;
    private boolean builtInZoomControls = true;
    private boolean displayZoomControls;
    private boolean verticalScrollBarEnabled;
    private boolean horizontalScrollBarEnabled;
    private boolean supportMultipleWindows = true;
    public static Browser.OnClickListener listener;
    private boolean geoLocationEnable;
    Handler mHandler = new Handler(Looper.getMainLooper()){

        public void handleMessage(Message msg) {
            Bundle bundle = msg.getData();
            if (bundle.getString(SinglePageBrowser.KEY_TITLE) != null) {
                SinglePageBrowser.this.textViewTitle.setText((CharSequence)bundle.getString(SinglePageBrowser.KEY_TITLE));
            } else {
                SinglePageBrowser.this.textViewTitle.setText((CharSequence)SinglePageBrowser.this.url);
            }
            if (bundle.getString(SinglePageBrowser.KEY_DESC) != null) {
                SinglePageBrowser.this.textViewSubTitle.setText((CharSequence)bundle.getString(SinglePageBrowser.KEY_DESC));
            } else {
                SinglePageBrowser.this.textViewSubTitle.setText((CharSequence)SinglePageBrowser.this.url);
            }
        }
    };

    public void startActivity(Context context, String url) {
        this.url = url;
        if (url != null) {
            Intent intent = new Intent(context, SinglePageBrowser.class);
            intent.putExtra(KEY_TITLE, this.copyToClipboardTitle).putExtra(KEY_TOAST_COPIED, this.toastMessageUrlCopied).putExtra(KEY_SUBJECT, this.shareSubject).putExtra(KEY_DESC, this.shareDescription).putExtra(KEY_BOUND_HOST, this.boundUrlToHost);
            context.startActivity(intent.putExtra(KEY_URL, url));
        }
    }

    public SinglePageBrowser setBuiltInZoomControls(boolean builtInZoomControls) {
        this.builtInZoomControls = builtInZoomControls;
        return this;
    }

    public SinglePageBrowser setGeoLocationEnable(boolean geoLocationEnable) {
        this.geoLocationEnable = geoLocationEnable;
        return this;
    }

    public SinglePageBrowser setDisplayZoomControls(boolean displayZoomControls) {
        this.displayZoomControls = displayZoomControls;
        return this;
    }

    public SinglePageBrowser setVerticalScrollBarEnabled(boolean verticalScrollBarEnabled) {
        this.verticalScrollBarEnabled = verticalScrollBarEnabled;
        return this;
    }

    public SinglePageBrowser setHorizontalScrollBarEnabled(boolean horizontalScrollBarEnabled) {
        this.horizontalScrollBarEnabled = horizontalScrollBarEnabled;
        return this;
    }

    public SinglePageBrowser setSupportMultipleWindows(boolean supportMultipleWindows) {
        this.supportMultipleWindows = supportMultipleWindows;
        return this;
    }

    public SinglePageBrowser setDisableJavascript(boolean disableJavascript) {
        this.disableJavascript = disableJavascript;
        return this;
    }

    public SinglePageBrowser setOnClickListener(Browser.OnClickListener onClickListener) {
        listener = onClickListener;
        return this;
    }

    public SinglePageBrowser setBoundUrlToHost(boolean boundUrlToHost) {
        this.boundUrlToHost = boundUrlToHost;
        return this;
    }

    public SinglePageBrowser setToastMessageUrlCopied(String toastMessageUrlCopied) {
        this.toastMessageUrlCopied = toastMessageUrlCopied;
        return this;
    }

    public SinglePageBrowser setCopyToClipboardTitle(String copyToClipboardTitle) {
        this.copyToClipboardTitle = copyToClipboardTitle;
        return this;
    }

    public SinglePageBrowser setShareSubject(String shareSubject, String shareDescription) {
        this.shareSubject = shareSubject;
        this.shareDescription = shareDescription;
        return this;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.library_single_page_browser);
        Intent intent = this.getIntent();
        this.url = intent.getStringExtra(KEY_URL);
        this.setToolBar();
        this.initializeView();
        this.overflowMenu();
        this.shareDescription = intent.getStringExtra(KEY_DESC);
        this.toastMessageUrlCopied = intent.getStringExtra(KEY_TOAST_COPIED);
        this.copyToClipboardTitle = intent.getStringExtra(KEY_TITLE);
        if (this.shareDescription == null) {
            this.shareDescription = this.url;
            this.shareSubject = !this.textViewTitle.getText().toString().startsWith(this.getString(R.string.library_string_loading)) ? this.textViewTitle.getText().toString() : "Url";
        }
        if (this.toastMessageUrlCopied == null) {
            this.toastMessageUrlCopied = "Copied to Clipboard";
        }
        if (this.copyToClipboardTitle == null) {
            this.copyToClipboardTitle = !this.textViewTitle.getText().toString().startsWith(this.getString(R.string.library_string_loading)) ? "URL-" + this.textViewTitle.getText().toString() : "URL";
        }
    }

    private void initializeView() {
        this.webView = (WebView)this.findViewById(R.id.id_web_view);
        if (CheckOs.checkForJellyBeanHighest()) {
            this.webView.addJavascriptInterface((Object)new WebAppInterface((Context)this), "Android");
        }
        WebSettings webSettings = this.webView.getSettings();
        if (this.disableJavascript) {
            if (CheckOs.checkForOreo()) {
                webSettings.setSafeBrowsingEnabled(true);
            }
            webSettings.setAppCacheEnabled(true);
            webSettings.setDomStorageEnabled(true);
            webSettings.setDisplayZoomControls(false);
        }
        webSettings.setGeolocationEnabled(this.geoLocationEnable);
        webSettings.setJavaScriptEnabled(!this.disableJavascript);
        webSettings.setSupportMultipleWindows(this.supportMultipleWindows);
        webSettings.setBuiltInZoomControls(this.builtInZoomControls);
        webSettings.setDisplayZoomControls(this.displayZoomControls);
        this.webView.setVerticalScrollBarEnabled(this.verticalScrollBarEnabled);
        this.webView.setHorizontalScrollBarEnabled(this.horizontalScrollBarEnabled);
        this.webView.setWebChromeClient(new WebChromeClient(){

            public void onProgressChanged(WebView view, int progress) {
                if (progress > 30 && progress < 85) {
                    SinglePageBrowser.this.webView.setVisibility(8);
                    SinglePageBrowser.this.progressBar.setIndeterminate(false);
                    SinglePageBrowser.this.progressBar.setProgress(progress);
                } else if (progress > 85) {
                    SinglePageBrowser.this.progressBar.setIndeterminate(false);
                    SinglePageBrowser.this.progressBar.setProgress(progress);
                    SinglePageBrowser.this.webView.setVisibility(0);
                } else {
                    SinglePageBrowser.this.progressBar.setIndeterminate(true);
                }
            }
        });
        final Uri uri = Uri.parse((String)this.url);
        this.webView.setWebViewClient(new WebViewClient(){

            public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
                if (SinglePageBrowser.this.boundUrlToHost && view.getUrl() != null) {
                    if (uri.getHost() != null && Uri.parse((String)view.getUrl()).getHost().startsWith(uri.getHost())) {
                        return false;
                    }
                    Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)view.getUrl()));
                    SinglePageBrowser.this.startActivity(intent);
                    return true;
                }
                return false;
            }

            public void onPageFinished(WebView view, String url) {
                super.onPageFinished(view, url);
                SinglePageBrowser.this.progressBar.setVisibility(8);
                SinglePageBrowser.this.currentUrl = url;
            }

            public void onPageStarted(WebView view, String url, Bitmap favicon) {
                super.onPageStarted(view, url, favicon);
                SinglePageBrowser.this.textViewTitle.setText(R.string.library_string_loading);
                SinglePageBrowser.this.textViewSubTitle.setText((CharSequence)url);
                SinglePageBrowser.this.progressBar.setVisibility(0);
                if (SinglePageBrowser.this.async != null) {
                    SinglePageBrowser.this.async.cancel(true);
                }
                SinglePageBrowser.this.async = new AsyncUrlParsing();
                SinglePageBrowser.this.async.execute(new String[]{url});
            }

            public void onSafeBrowsingHit(WebView view, WebResourceRequest request, int threatType, SafeBrowsingResponse callback) {
                if (CheckOs.checkForOreoHighest()) {
                    callback.backToSafety(true);
                }
            }

            public boolean onRenderProcessGone(WebView view, RenderProcessGoneDetail detail) {
                if (CheckOs.checkForOreo() && !detail.didCrash()) {
                    if (SinglePageBrowser.this.webView != null) {
                        ViewGroup webViewContainer = (ViewGroup)SinglePageBrowser.this.findViewById(R.id.id_web_view);
                        webViewContainer.removeView((View)SinglePageBrowser.this.webView);
                        SinglePageBrowser.this.webView.destroy();
                        SinglePageBrowser.this.webView = null;
                    }
                    return true;
                }
                return false;
            }
        });
        if (CheckOs.checkForOreo()) {
            this.webView.setRendererPriorityPolicy(1, true);
        }
        this.webView.loadUrl(this.url);
        this.textViewTitle.setText(R.string.library_string_loading);
        this.textViewSubTitle.setText((CharSequence)this.url);
        this.findViewById(R.id.id_image_back).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SinglePageBrowser.this.onBackPressed();
            }
        });
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == 4 && this.webView.canGoBack()) {
            this.webView.goBack();
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }

    private void setToolBar() {
        this.progressBar = (ProgressBar)this.findViewById(R.id.id_progress_bar);
        this.textViewSubTitle = (TextView)this.findViewById(R.id.id_text_sub_title);
        this.textViewTitle = (TextView)this.findViewById(R.id.id_text_title);
    }

    private void overflowMenu() {
        this.findViewById(R.id.id_image_overflow).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                int[] location = new int[2];
                v.getLocationOnScreen(location);
                Point point = new Point();
                point.x = location[0];
                point.y = location[1];
                SinglePageBrowser.this.popupWindow(point);
            }
        });
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == 16908332) {
            this.onBackPressed();
        }
        return super.onOptionsItemSelected(item);
    }

    public void onBackPressed() {
        if (this.changeStatusPopUp != null && this.changeStatusPopUp.isShowing()) {
            this.changeStatusPopUp.dismiss();
        } else if (this.webView.canGoBack()) {
            this.webView.goBack();
        } else {
            if (this.async != null) {
                this.async.cancel(true);
            }
            this.webView.clearCache(true);
            this.webView.clearHistory();
            super.onBackPressed();
        }
    }

    private void popupWindow(Point p) {
        LayoutInflater layoutInflater = (LayoutInflater)this.getSystemService("layout_inflater");
        View layout2 = layoutInflater.inflate(R.layout.library_popup_browser, null);
        this.changeStatusPopUp = new HelperDialogCommon().popupWindow(layout2, (Context)this, p);
        layout2.findViewById(R.id.id_linear_open).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SinglePageBrowser.this.changeStatusPopUp.dismiss();
                SinglePageBrowser.this.startMoreOptions();
                if (listener != null) {
                    listener.onClickOptionMenu(2, SinglePageBrowser.this.currentUrl);
                }
            }
        });
        layout2.findViewById(R.id.id_linear_share_link).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SinglePageBrowser.this.changeStatusPopUp.dismiss();
                new PickerShareFiles().setThings((Context)SinglePageBrowser.this).shareThings(SinglePageBrowser.this.getSupportFragmentManager(), SinglePageBrowser.this.shareDescription, SinglePageBrowser.this.shareSubject);
                if (listener != null) {
                    listener.onClickOptionMenu(3, SinglePageBrowser.this.currentUrl);
                }
            }
        });
        layout2.findViewById(R.id.id_linear_copy_link).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SinglePageBrowser.this.changeStatusPopUp.dismiss();
                SinglePageBrowser.this.copyToClipboard();
                if (listener != null) {
                    listener.onClickOptionMenu(1, SinglePageBrowser.this.currentUrl);
                }
            }
        });
    }

    public void startMoreOptions() {
        Intent shareData = new Intent("android.intent.action.VIEW", Uri.parse((String)this.url));
        Intent intentChooser = Intent.createChooser((Intent)shareData, (CharSequence)"Share to");
        if (shareData.resolveActivity(this.getPackageManager()) != null) {
            this.startActivity(intentChooser);
        } else {
            MySnackBar.getInstance().showSnackBarForMessage((Activity)this, "Sorry! Browser not Found");
        }
    }

    private void copyToClipboard() {
        ClipboardManager clipboardManager = (ClipboardManager)this.getSystemService("clipboard");
        ClipData clipData = ClipData.newPlainText((CharSequence)this.copyToClipboardTitle, (CharSequence)this.url);
        if (clipboardManager != null) {
            clipboardManager.setPrimaryClip(clipData);
            Toast.makeText((Context)this, (CharSequence)this.toastMessageUrlCopied, (int)0).show();
        }
    }

    public class WebAppInterface {
        Context mContext;

        WebAppInterface(Context c) {
            this.mContext = c;
        }

        @JavascriptInterface
        public void showToast(String toast) {
            Toast.makeText((Context)this.mContext, (CharSequence)toast, (int)0).show();
        }
    }

    @SuppressLint(value={"StaticFieldLeak"})
    private class AsyncUrlParsing
    extends AsyncTask<String, Void, String> {
        String text;
        String desc = null;

        private AsyncUrlParsing() {
        }

        protected String doInBackground(String ... params) {
            return this.parseUrl(params[0]);
        }

        private String parseUrl(String url) {
            Document document = null;
            try {
                document = Jsoup.connect((String)url).get();
                Elements metaOgTitle = document.select("meta[property=og:title]");
                this.text = metaOgTitle != null ? metaOgTitle.attr("content") : document.title();
                Elements description = document.select("meta[name=description]");
                if (description != null) {
                    this.desc = description.attr("content");
                }
                return "S";
            }
            catch (IOException e) {
                Log.e((String)"Jamun-Browser", (String)e.getMessage());
                return null;
            }
        }

        protected void onPostExecute(String aVoid) {
            super.onPostExecute((Object)aVoid);
            if (aVoid != null) {
                Message m = Message.obtain();
                Bundle bundle = new Bundle();
                bundle.putString(SinglePageBrowser.KEY_TITLE, this.text);
                bundle.putString(SinglePageBrowser.KEY_DESC, this.desc);
                m.setData(bundle);
                SinglePageBrowser.this.mHandler.sendMessage(m);
            }
        }
    }
}

