/*
 * Decompiled with CFR 0.152.
 */
package tk.jamun.ui.share.views;

import android.annotation.SuppressLint;
import android.app.Dialog;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.design.widget.BottomSheetDialogFragment;
import android.support.v4.app.FragmentManager;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import java.util.ArrayList;
import tk.jamun.ui.share.R;
import tk.jamun.ui.share.models.ModelIntentPicker;

public class PickerIntent
extends BottomSheetDialogFragment {
    public static int PICKER_CAMERA = 1;
    public static int PICKER_GALLERY = 2;
    public static int PICKER_MANAGER = 3;
    public static int PICKER_REMOVE = 4;
    private Context context;
    private ArrayList<ModelIntentPicker> arrayList = new ArrayList();
    private OnClickListener onClickListener;
    private String title;

    public PickerIntent() {
        this.setStyle(0, R.style.LibraryBottomSheetDialogTheme);
    }

    public PickerIntent setPicker(@NonNull String title, @NonNull ArrayList<ModelIntentPicker> arrayList, OnClickListener onClickListener) {
        this.title = title;
        this.onClickListener = onClickListener;
        this.arrayList = arrayList;
        return this;
    }

    public void showPicker(FragmentManager fragmentManager) {
        this.show(fragmentManager, this.getTag());
    }

    public PickerIntent setThings(Context context) {
        this.context = context;
        return this;
    }

    @SuppressLint(value={"RestrictedApi"})
    public void setupDialog(Dialog dialog, int style2) {
        super.setupDialog(dialog, style2);
        View view = View.inflate((Context)this.getContext(), (int)R.layout.library_intent_picker, null);
        dialog.setContentView(view);
        TextView textView = (TextView)view.findViewById(R.id.id_text_title);
        if (this.title != null) {
            textView.setText((CharSequence)this.title);
        }
        RecyclerView recyclerView = (RecyclerView)view.findViewById(R.id.id_recycler_view);
        recyclerView.setLayoutManager((RecyclerView.LayoutManager)new GridLayoutManager(this.context, 3));
        RecyclerAdapterCountry recyclerAdapter = new RecyclerAdapterCountry();
        recyclerView.setAdapter((RecyclerView.Adapter)recyclerAdapter);
        view.findViewById(R.id.id_button_cancel).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PickerIntent.this.dismiss();
            }
        });
        recyclerAdapter.notifyDataSetChanged();
    }

    class RecyclerAdapterCountry
    extends RecyclerView.Adapter<ViewHolder> {
        RecyclerAdapterCountry() {
        }

        @NonNull
        public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
            return new ViewHolder(LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.library_intent_picker_recycler, parent, false));
        }

        public void onBindViewHolder(@NonNull ViewHolder holder, int position) {
            ModelIntentPicker modelIntentPicker = (ModelIntentPicker)PickerIntent.this.arrayList.get(position);
            holder.imageView.setImageResource(modelIntentPicker.getIcon());
            holder.textView.setText((CharSequence)modelIntentPicker.getName());
            holder.imageView.setBackgroundResource(modelIntentPicker.getBackground());
        }

        public int getItemCount() {
            return PickerIntent.this.arrayList.size();
        }

        public class ViewHolder
        extends RecyclerView.ViewHolder
        implements View.OnClickListener {
            private TextView textView;
            private ImageView imageView;

            public ViewHolder(View itemView) {
                super(itemView);
                this.textView = (TextView)itemView.findViewById(R.id.id_text);
                this.imageView = (ImageView)itemView.findViewById(R.id.id_image);
                itemView.setOnClickListener((View.OnClickListener)this);
            }

            public void onClick(View v) {
                ModelIntentPicker modelIntentPicker = (ModelIntentPicker)PickerIntent.this.arrayList.get(this.getAdapterPosition());
                if (PickerIntent.this.onClickListener != null) {
                    PickerIntent.this.onClickListener.onClick(modelIntentPicker);
                }
            }
        }
    }

    public static interface OnClickListener {
        public void onClick(ModelIntentPicker var1);
    }
}

