/*
 * Decompiled with CFR 0.152.
 */
package tk.jamun.ui.pickers.views.language;

import android.annotation.SuppressLint;
import android.app.Dialog;
import android.content.Context;
import android.support.design.widget.BottomSheetDialogFragment;
import android.support.v4.app.FragmentManager;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.View;
import android.widget.EditText;
import java.util.ArrayList;
import tk.jamun.ui.pickers.R;
import tk.jamun.ui.pickers.adapters.RecyclerAdapterLanguage;
import tk.jamun.ui.pickers.extras.PickerListenerLanguage;
import tk.jamun.ui.pickers.extras.UtilityClassLanguage;
import tk.jamun.ui.pickers.models.ModelLanguage;
import tk.jamun.ui.pickers.models.ModelLanguageParent;

public class PickerLanguageBottom
extends BottomSheetDialogFragment {
    private ArrayList<ModelLanguageParent> arrayList = new ArrayList();
    private String searchData = "";
    private PickerListenerLanguage pickerListener;
    private RecyclerAdapterLanguage recyclerAdapterLanguage;
    private EditText editText;
    private UtilityClassLanguage utilityClass;
    private boolean found;
    private Context context;
    private int mode = 0;
    private View view;
    private boolean selectionModeMulti;
    private ArrayList<ModelLanguage> languageArrayListSelected;
    private String editTextHint;

    public PickerLanguageBottom() {
        this.setStyle(0, R.style.LibraryBottomSheetDialogTheme);
    }

    public PickerLanguageBottom setThings(Context context, ArrayList<ModelLanguageParent> arrayList) {
        this.context = context;
        this.arrayList = arrayList;
        return this;
    }

    public PickerLanguageBottom setMode(int mode) {
        this.mode = mode;
        return this;
    }

    public PickerLanguageBottom setSelectionModeMulti(boolean selectionModeMulti) {
        this.selectionModeMulti = selectionModeMulti;
        if (selectionModeMulti) {
            this.languageArrayListSelected = new ArrayList();
        }
        return this;
    }

    public PickerLanguageBottom setEditTextHint(String editTextHint) {
        this.editTextHint = editTextHint;
        return this;
    }

    public PickerLanguageBottom bindListener(PickerListenerLanguage pickerListener) {
        this.pickerListener = pickerListener;
        return this;
    }

    public void showPicker(FragmentManager fragmentManager) {
        this.show(fragmentManager, this.getTag());
    }

    @SuppressLint(value={"RestrictedApi"})
    public void setupDialog(Dialog dialog, int style2) {
        super.setupDialog(dialog, style2);
        if (this.view == null) {
            this.utilityClass = new UtilityClassLanguage();
            this.utilityClass.initializeData(this.arrayList, this.context, this.mode);
        }
        this.view = View.inflate((Context)this.getContext(), (int)R.layout.library_language_bottom, null);
        dialog.setContentView(this.view);
        this.initializeView(this.view);
    }

    private void initializeView(final View view) {
        if (this.selectionModeMulti) {
            view.findViewById(R.id.id_float).setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    PickerLanguageBottom.this.pickerListener.multiModeData(PickerLanguageBottom.this.languageArrayListSelected);
                    PickerLanguageBottom.this.dismiss();
                }
            });
        }
        RecyclerView recyclerView = (RecyclerView)view.findViewById(R.id.id_recycler_view);
        recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.context));
        this.utilityClass.setRecyclerViewCache(recyclerView, 20, true);
        this.recyclerAdapterLanguage = new RecyclerAdapterLanguage(this.arrayList, new PickerListenerLanguage(){

            @Override
            public void singleModeData(ModelLanguage modelLanguage) {
                super.singleModeData(modelLanguage);
                if (PickerLanguageBottom.this.selectionModeMulti) {
                    if (PickerLanguageBottom.this.languageArrayListSelected.indexOf(modelLanguage) == -1) {
                        PickerLanguageBottom.this.languageArrayListSelected.add(modelLanguage);
                    } else {
                        PickerLanguageBottom.this.languageArrayListSelected.remove(modelLanguage);
                    }
                    if (PickerLanguageBottom.this.languageArrayListSelected.isEmpty()) {
                        view.findViewById(R.id.id_float).setVisibility(8);
                    } else {
                        view.findViewById(R.id.id_float).setVisibility(0);
                    }
                } else {
                    PickerLanguageBottom.this.dismiss();
                    if (PickerLanguageBottom.this.pickerListener != null) {
                        PickerLanguageBottom.this.pickerListener.singleModeData(modelLanguage);
                    }
                }
            }
        }, this.context, this.selectionModeMulti);
        recyclerView.setAdapter((RecyclerView.Adapter)this.recyclerAdapterLanguage);
        this.editText = (EditText)view.findViewById(R.id.id_edit_search);
        this.editText.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View v, boolean hasFocus) {
                if (hasFocus) {
                    view.findViewById(R.id.id_view_keyboard).setVisibility(0);
                } else {
                    view.findViewById(R.id.id_view_keyboard).setVisibility(8);
                }
            }
        });
        final ArrayList newArrayListParent = new ArrayList();
        if (this.editTextHint != null) {
            this.editText.setHint((CharSequence)this.editTextHint);
        }
        this.editText.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
                if (TextUtils.isEmpty((CharSequence)s)) {
                    PickerLanguageBottom.this.recyclerAdapterLanguage.updateAdapter(PickerLanguageBottom.this.arrayList);
                    view.findViewById(R.id.id_image_clear).setVisibility(8);
                } else {
                    PickerLanguageBottom.this.searchData = PickerLanguageBottom.this.utilityClass.fixText(s.toString());
                    view.findViewById(R.id.id_image_clear).setVisibility(0);
                    newArrayListParent.clear();
                    for (ModelLanguageParent modelLanguageParent : PickerLanguageBottom.this.arrayList) {
                        ArrayList<ModelLanguage> newArrayList = new ArrayList<ModelLanguage>();
                        for (ModelLanguage modelLanguage : modelLanguageParent.getArrayList()) {
                            if (!modelLanguage.getTitle().contains(PickerLanguageBottom.this.searchData)) continue;
                            ModelLanguage modelLanguageNew = new ModelLanguage();
                            modelLanguageNew.setId(modelLanguage.getId());
                            modelLanguageNew.setLanguage(modelLanguage.getLanguage());
                            modelLanguageNew.setSelected(modelLanguage.isSelected());
                            PickerLanguageBottom.this.found = true;
                            modelLanguageNew.setTitle(PickerLanguageBottom.this.utilityClass.implementThingsForSearch(modelLanguage.getTitle(), PickerLanguageBottom.this.searchData));
                            newArrayList.add(modelLanguageNew);
                        }
                        if (!PickerLanguageBottom.this.found) continue;
                        newArrayListParent.add(new ModelLanguageParent(newArrayList, modelLanguageParent.getTitle()));
                        PickerLanguageBottom.this.found = false;
                    }
                    PickerLanguageBottom.this.recyclerAdapterLanguage.updateAdapter(newArrayListParent);
                }
            }

            public void afterTextChanged(Editable s) {
            }
        });
        this.editText.setText((CharSequence)this.searchData);
        view.findViewById(R.id.id_image_back).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (!TextUtils.isEmpty((CharSequence)PickerLanguageBottom.this.editText.getText())) {
                    PickerLanguageBottom.this.editText.setText((CharSequence)"");
                    PickerLanguageBottom.this.searchData = "";
                } else {
                    PickerLanguageBottom.this.dismiss();
                }
            }
        });
        view.findViewById(R.id.id_image_clear).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PickerLanguageBottom.this.editText.setText((CharSequence)"");
            }
        });
        this.recyclerAdapterLanguage.updateAdapter(this.arrayList);
    }

    public void clear() {
        if (this.arrayList != null) {
            this.arrayList.clear();
        }
        this.arrayList = null;
        this.pickerListener = null;
    }
}

