/*
 * Decompiled with CFR 0.152.
 */
package tk.jamun.ui.pickers.views.country;

import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.design.widget.FloatingActionButton;
import android.support.v4.app.Fragment;
import android.support.v7.app.AlertDialog;
import android.support.v7.app.AppCompatActivity;
import android.view.View;
import java.util.ArrayList;
import tk.jamun.ui.pickers.R;
import tk.jamun.ui.pickers.extras.PickerListenerCountry;
import tk.jamun.ui.pickers.models.ModelCountry;
import tk.jamun.ui.pickers.models.ModelCountryDetails;
import tk.jamun.ui.pickers.views.country.PickerCountryNavigation;

public class PickerCountryActivity
extends AppCompatActivity {
    private static PickerListenerCountry pickerListener;
    private boolean selectionModeMulti;
    private ArrayList<ModelCountry> arrayListSelected;
    private FloatingActionButton floatingActionButton;

    public static void setThings(Context context, PickerListenerCountry pickerListenerCountry, ModelCountryDetails modelCountryDetails, boolean selectionModeMulti) {
        pickerListener = pickerListenerCountry;
        context.startActivity(new Intent(context, PickerCountryActivity.class).putExtra("data", (Parcelable)modelCountryDetails).putExtra("selMode", selectionModeMulti));
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.library_country_activity);
        this.selectionModeMulti = this.getIntent().getBooleanExtra("selMode", false);
        if (this.selectionModeMulti) {
            this.arrayListSelected = new ArrayList();
            this.floatingActionButton = (FloatingActionButton)this.findViewById(R.id.id_float);
            this.floatingActionButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    pickerListener.multiModeData(PickerCountryActivity.this.arrayListSelected);
                    PickerCountryActivity.this.onBackPressed();
                }
            });
        }
        this.getSupportFragmentManager().beginTransaction().add(R.id.id_frag, (Fragment)PickerCountryNavigation.getInstance(new PickerListenerCountry(){

            @Override
            public void singleModeData(ModelCountry modelCountry) {
                super.singleModeData(modelCountry);
                if (PickerCountryActivity.this.selectionModeMulti) {
                    if (PickerCountryActivity.this.arrayListSelected.indexOf(modelCountry) == -1) {
                        PickerCountryActivity.this.arrayListSelected.add(modelCountry);
                    } else {
                        PickerCountryActivity.this.arrayListSelected.remove(modelCountry);
                    }
                    if (PickerCountryActivity.this.arrayListSelected.isEmpty()) {
                        PickerCountryActivity.this.floatingActionButton.setVisibility(8);
                    } else {
                        PickerCountryActivity.this.floatingActionButton.setVisibility(0);
                    }
                } else {
                    if (pickerListener != null) {
                        pickerListener.singleModeData(modelCountry);
                    }
                    PickerCountryActivity.this.onBackPressed();
                }
            }

            @Override
            public void apiError(int statusCode, String errorMessage) {
                pickerListener.apiError(statusCode, errorMessage);
            }
        }, (ModelCountryDetails)this.getIntent().getParcelableExtra("data"), this.selectionModeMulti), "FragNav").commit();
    }

    public void onBackPressed() {
        if (this.selectionModeMulti && this.arrayListSelected != null && !this.arrayListSelected.isEmpty()) {
            new AlertDialog.Builder((Context)this).setMessage(R.string.library_string_are_you_sure).setCancelable(true).setPositiveButton(R.string.library_string_button_name_yes, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    dialog.dismiss();
                    PickerCountryActivity.this.arrayListSelected.clear();
                    PickerCountryActivity.this.finish();
                }
            }).setNegativeButton(R.string.library_string_button_name_no, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    dialog.dismiss();
                }
            }).show();
        } else {
            super.onBackPressed();
        }
    }
}

