/*
 * Decompiled with CFR 0.152.
 */
package tk.jamun.ui.pickers.adapters;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.v7.widget.AppCompatImageView;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.android.volley.toolbox.NetworkImageView;
import java.util.ArrayList;
import tk.jamun.ui.pickers.R;
import tk.jamun.ui.pickers.extras.PickerListenerCountry;
import tk.jamun.ui.pickers.models.ModelCountry;
import tk.jamun.volley.classes.VolleyImageDownload;

public class RecyclerAdapterCountry
extends RecyclerView.Adapter<ViewHolder> {
    private ArrayList<ModelCountry> arrayList;
    private String imagePath;
    private PickerListenerCountry pickerListener;
    private boolean selectionModeMulti;
    private boolean isSomeoneSelectedFirst;

    public RecyclerAdapterCountry(ArrayList<ModelCountry> arrayList, String imagePath, PickerListenerCountry pickerListener, boolean selectionModeMulti) {
        this.arrayList = arrayList;
        this.pickerListener = pickerListener;
        this.imagePath = imagePath;
        this.selectionModeMulti = selectionModeMulti;
    }

    public void update(ArrayList<ModelCountry> arrayList) {
        this.arrayList = arrayList;
        this.notifyDataSetChanged();
    }

    public void setDataChanged(ArrayList<ModelCountry> arrayList) {
        this.arrayList = arrayList;
        this.notifyDataSetChanged();
    }

    @NonNull
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new ViewHolder(LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.library_country_recycler, parent, false));
    }

    public void onBindViewHolder(@NonNull ViewHolder holder, int position) {
        ModelCountry modelCountry = this.arrayList.get(position);
        if (modelCountry.isSelected()) {
            holder.imageViewCheck.setVisibility(0);
            this.isSomeoneSelectedFirst = true;
        } else {
            holder.imageViewCheck.setVisibility(8);
        }
        holder.textViewName.setText((CharSequence)(modelCountry.getCountryName() + " (" + modelCountry.getCountryISO() + ")"));
        holder.textViewCode.setText((CharSequence)("+" + modelCountry.getCountryCode()));
        VolleyImageDownload.getInstance().downloadImage(this.imagePath + modelCountry.getFlagUrl(), holder.imageView, R.drawable.library_placeholder_image_light);
        modelCountry.setChildPosition(position);
    }

    public int getItemCount() {
        return this.arrayList.size();
    }

    class ViewHolder
    extends RecyclerView.ViewHolder
    implements View.OnClickListener {
        private TextView textViewName;
        private TextView textViewCode;
        private NetworkImageView imageView;
        private AppCompatImageView imageViewCheck;

        ViewHolder(View v) {
            super(v);
            this.imageView = (NetworkImageView)v.findViewById(R.id.id_image);
            this.textViewCode = (TextView)v.findViewById(R.id.id_text_code);
            this.textViewName = (TextView)v.findViewById(R.id.id_text_name);
            this.imageViewCheck = (AppCompatImageView)v.findViewById(R.id.id_image_check);
            v.setOnClickListener((View.OnClickListener)this);
        }

        public void onClick(View view) {
            if (!RecyclerAdapterCountry.this.selectionModeMulti && RecyclerAdapterCountry.this.isSomeoneSelectedFirst) {
                for (ModelCountry modelCountry : RecyclerAdapterCountry.this.arrayList) {
                    if (!modelCountry.isSelected()) continue;
                    modelCountry.setSelected(false);
                    RecyclerAdapterCountry.this.notifyItemChanged(modelCountry.getChildPosition());
                }
            }
            ModelCountry modelCountry = (ModelCountry)RecyclerAdapterCountry.this.arrayList.get(this.getAdapterPosition());
            modelCountry.setCountryCodeWithPlus("+" + modelCountry.getCountryCode());
            modelCountry.setFlagUrl(modelCountry.getFlagUrl());
            if (RecyclerAdapterCountry.this.selectionModeMulti && modelCountry.isSelected()) {
                modelCountry.setSelected(false);
                this.imageViewCheck.setVisibility(8);
            } else {
                modelCountry.setSelected(true);
                this.imageViewCheck.setVisibility(0);
                RecyclerAdapterCountry.this.isSomeoneSelectedFirst = true;
            }
            RecyclerAdapterCountry.this.pickerListener.singleModeData(modelCountry);
        }
    }
}

