/*
 * Decompiled with CFR 0.152.
 */
package tk.hongkailiu.test.webapp.controller;

import org.apache.log4j.Logger;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class MainController {
    private static final Logger logger = Logger.getLogger(MainController.class);

    @RequestMapping(value={"/index"}, method={RequestMethod.GET})
    public ModelAndView index() {
        logger.debug((Object)"==============index page==================");
        ModelAndView model = new ModelAndView();
        model.setViewName("index");
        return model;
    }

    @RequestMapping(value={"/", "/welcome**"}, method={RequestMethod.GET})
    public ModelAndView defaultPage() {
        logger.debug((Object)"==============default page==================");
        ModelAndView model = new ModelAndView();
        model.addObject("title", (Object)"Spring Security Login Form - Database Authentication");
        model.addObject("message", (Object)"This is default page!");
        model.setViewName("hello");
        return model;
    }

    @RequestMapping(value={"/admin**"}, method={RequestMethod.GET})
    public ModelAndView adminPage() {
        ModelAndView model = new ModelAndView();
        model.addObject("title", (Object)"Spring Security Login Form - Database Authentication");
        model.addObject("message", (Object)"This page is for ROLE_ADMIN only!");
        model.setViewName("admin");
        return model;
    }

    @RequestMapping(value={"/login"}, method={RequestMethod.GET})
    public ModelAndView login(@RequestParam(value="error", required=false) String error, @RequestParam(value="logout", required=false) String logout) {
        ModelAndView model = new ModelAndView();
        if (error != null) {
            model.addObject("error", (Object)"Invalid username and password!");
        }
        if (logout != null) {
            model.addObject("msg", (Object)"You've been logged out successfully.");
        }
        model.setViewName("login");
        return model;
    }

    @RequestMapping(value={"/403"}, method={RequestMethod.GET})
    public ModelAndView accesssDenied() {
        ModelAndView model = new ModelAndView();
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (!(auth instanceof AnonymousAuthenticationToken)) {
            UserDetails userDetail = (UserDetails)auth.getPrincipal();
            System.out.println(userDetail);
            model.addObject("username", (Object)userDetail.getUsername());
        }
        model.setViewName("403");
        return model;
    }
}

