/*
 * Decompiled with CFR 0.152.
 */
package th.or.nectec.android.library.widget;

import android.app.Fragment;
import android.app.FragmentManager;
import android.app.FragmentTransaction;
import android.content.Context;
import android.database.Cursor;
import android.os.Bundle;
import android.util.AttributeSet;
import android.widget.CursorAdapter;
import android.widget.Spinner;
import android.widget.SpinnerAdapter;
import th.or.nectec.android.library.widget.CursorStringIdAdapter;
import th.or.nectec.android.library.widget.HighLightCursorAdapter;
import th.or.nectec.android.library.widget.SearchListDialog;

public class SearchableSpinner
extends Spinner
implements SearchListDialog.ItemClickListener {
    SearchListDialog f;
    FragmentManager fm;
    String tag;
    HighLightCursorAdapter mAdapter;
    static int count = 0;

    public SearchableSpinner(Context context, FragmentManager fm, Class<? extends SearchListDialog> cls, String tag) {
        super(context);
        this.setDialog(fm, cls, tag);
    }

    public SearchableSpinner(Context context) {
        super(context);
    }

    public SearchableSpinner(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public SearchableSpinner setDialog(FragmentManager fm, Class<? extends SearchListDialog> cls, Bundle args, String tag) {
        this.tag = tag;
        this.fm = fm;
        Fragment prev = fm.findFragmentByTag(tag);
        this.f = prev != null ? (SearchListDialog)prev : (SearchListDialog)Fragment.instantiate((Context)this.getContext(), (String)cls.getName(), (Bundle)args);
        Cursor c = this.getContext().getContentResolver().query(this.f.getContentUri(), this.f.getProjection(), null, null, "_id");
        this.mAdapter = new HighLightCursorAdapter(this.getContext(), this.f.getLayout(), c, this.f.getFrom(), this.f.getTo());
        this.f.setItemClickListener(this);
        this.setAdapter((SpinnerAdapter)this.mAdapter);
        return this;
    }

    public SearchableSpinner setDialog(FragmentManager fm, Class<? extends SearchListDialog> cls, String tag) {
        return this.setDialog(fm, cls, null, tag);
    }

    public boolean performClick() {
        boolean handle = false;
        if (!handle && this.fm != null) {
            FragmentTransaction ft = this.fm.beginTransaction();
            Fragment prev = this.fm.findFragmentByTag(this.tag);
            if (prev != null) {
                ft.remove(prev);
            }
            ft.addToBackStack(null);
            if (this.f != null) {
                this.f.setItemClickListener(this);
                this.f.show(ft, this.tag);
            }
        }
        return handle;
    }

    public void setSelectionById(long id2) {
        this.setSelection(SearchableSpinner.binarySearch(this.mAdapter, id2, 0, this.mAdapter.getCount()), true);
    }

    private static final int binarySearch(CursorAdapter adapter, long id2, int min, int max) {
        if (max < min) {
            return 0;
        }
        int mid = (max + min) / 2;
        long curId = adapter.getItemId(mid);
        if (curId > id2) {
            return SearchableSpinner.binarySearch(adapter, id2, min, mid - 1);
        }
        if (curId < id2) {
            return SearchableSpinner.binarySearch(adapter, id2, mid + 1, max);
        }
        return mid;
    }

    @Override
    public void onItemClick(HighLightCursorAdapter adapter, long id2, int position) {
        this.f.dismiss();
        this.setSelection(SearchableSpinner.binarySearch(this.mAdapter, id2, 0, this.mAdapter.getCount()), true);
    }

    @Override
    public void onItemClick(CursorStringIdAdapter adapter, String id2, String text) {
        throw new IllegalArgumentException("SearchableSpinner not support for CursorStringIdAdapter dialog");
    }
}

