/*
 * Decompiled with CFR 0.152.
 */
package th.or.nectec.android.library.widget;

import android.app.Fragment;
import android.app.FragmentManager;
import android.app.FragmentTransaction;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import th.or.nectec.android.library.R;
import th.or.nectec.android.library.widget.CursorStringIdAdapter;
import th.or.nectec.android.library.widget.HighLightCursorAdapter;
import th.or.nectec.android.library.widget.SearchListDialog;

public class SearchableButton
extends Button
implements SearchListDialog.ItemClickListener {
    private String selectId;
    private String tag;
    private FragmentManager fm;
    private SearchListDialog f;
    private OnItemSelectListener mListener;

    public SearchableButton(Context context, AttributeSet attrs) {
        super(context, attrs, 16842862);
        if (!this.isInEditMode()) {
            this.init();
        }
    }

    private void init() {
        this.setGravity(3);
        this.setMaxLines(2);
        this.setTextSize(2, 16.0f);
        float density = this.getResources().getDisplayMetrics().density;
        int paddingLR = (int)(this.getResources().getDimension(R.dimen.text_padding) * density);
        int paddingT = (int)((float)this.getResources().getDimensionPixelSize(R.dimen.edittext_padding_top) * density);
        int paddingB = (int)((float)this.getResources().getDimensionPixelSize(R.dimen.edittext_padding_buttom) * density);
        this.setPadding(paddingLR, paddingT, paddingLR, paddingB);
        this.setGravity(16);
        this.setFocusable(false);
    }

    public SearchableButton setDialog(FragmentManager fm, Class<? extends SearchListDialog.BaseAdapter> cls, Bundle args, String tag) {
        this.tag = tag;
        this.fm = fm;
        Fragment prev = fm.findFragmentByTag(tag);
        this.f = prev != null ? (SearchListDialog)prev : (SearchListDialog)Fragment.instantiate((Context)this.getContext(), (String)cls.getName(), (Bundle)args);
        this.f.setItemClickListener(this);
        return this;
    }

    public SearchableButton setDialog(FragmentManager fm, Class<? extends SearchListDialog.BaseAdapter> cls, String tag) {
        return this.setDialog(fm, cls, null, tag);
    }

    public boolean performClick() {
        boolean handle = false;
        if (!handle && this.fm != null) {
            FragmentTransaction ft = this.fm.beginTransaction();
            Fragment prev = this.fm.findFragmentByTag(this.tag);
            if (prev != null) {
                ft.remove(prev);
            }
            ft.addToBackStack(null);
            if (this.f != null) {
                this.f.setItemClickListener(this);
                this.f.show(ft, this.tag);
                handle = true;
            }
        }
        return handle;
    }

    public String getSelectId() {
        return this.selectId;
    }

    public void setSelectionById(String id2) {
        if (!TextUtils.isEmpty((CharSequence)id2)) {
            Uri uri = Uri.withAppendedPath((Uri)this.f.getContentUri(), (String)id2);
            Cursor c = this.getContext().getContentResolver().query(uri, new String[]{"name"}, null, null, null);
            if (c.moveToFirst()) {
                this.selectId = id2;
                this.setText(c.getString(0));
                Log.d((String)"SB", (String)c.getString(0));
            } else {
                Log.d((String)"SB", (String)"not found");
            }
        } else {
            Log.d((String)"SB", (String)"Null id");
        }
    }

    public void setSelectionById(String id2, String partialSelection) {
        Uri uri = this.f.getContentUri();
        Cursor c = this.getContext().getContentResolver().query(uri, new String[]{"name"}, partialSelection, new String[]{id2}, null);
        if (c.moveToFirst()) {
            this.selectId = id2;
            this.setText(c.getString(0));
            Log.d((String)"SB", (String)c.getString(0));
        } else {
            Log.d((String)"SB", (String)"Null id");
        }
    }

    public void setSelectionByValue(String value, String selection) {
        Uri uri = this.f.getContentUri();
        Cursor c = this.getContext().getContentResolver().query(uri, new String[]{"_id"}, selection, new String[]{value}, null);
        if (c.moveToFirst()) {
            this.selectId = c.getString(0);
            this.setText(value);
        }
    }

    public void clearSelection() {
        this.selectId = null;
        this.setText("");
    }

    @Override
    public void onItemClick(HighLightCursorAdapter adapter, long id2, int position) {
        throw new IllegalArgumentException("SearchableButton not support for HighLightCursorAdapter");
    }

    @Override
    public void onItemClick(CursorStringIdAdapter adapter, String id2, String text) {
        this.f.dismiss();
        this.selectId = id2;
        this.setText(text);
        this.getSelectId();
        if (this.mListener != null) {
            this.mListener.onItemSelect(id2);
        }
    }

    public void setOnItemSelectListener(OnItemSelectListener listener) {
        this.mListener = listener;
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState ss = new SavedState(superState);
        ss.id = this.selectId;
        ss.text = this.getText().toString();
        return ss;
    }

    public void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof SavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.selectId = ss.id;
        this.setText(ss.text);
    }

    static class SavedState
    extends View.BaseSavedState {
        String id;
        String text;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            this.id = in.readString();
            this.text = in.readString();
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeString(this.id);
            out.writeString(this.text);
        }
    }

    public static interface OnItemSelectListener {
        public void onItemSelect(String var1);
    }
}

