/*
 * Decompiled with CFR 0.152.
 */
package th.or.nectec.android.library.widget;

import android.content.Context;
import android.os.Handler;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.Editable;
import android.text.InputFilter;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.LinearLayout;

public class NumberPicker
extends LinearLayout {
    private final long REPEAT_DELAY = 50L;
    final float scale;
    private final int ELEMENT_HEIGHT;
    private final int ELEMENT_WIDTH;
    private final int MINIMUM = 0;
    private final int MAXIMUM = 99;
    public Integer value;
    Button decrement;
    Button increment;
    public EditText valueText;
    private Handler repeatUpdateHandler;
    private boolean autoIncrement;
    private boolean autoDecrement;
    OnValueChangeListener mValueListener;

    public NumberPicker(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.scale = this.getContext().getResources().getDisplayMetrics().density;
        this.ELEMENT_WIDTH = this.ELEMENT_HEIGHT = (int)(50.0f * this.scale + 0.5f);
        this.MINIMUM = 0;
        this.MAXIMUM = 99;
        this.repeatUpdateHandler = new Handler();
        this.autoIncrement = false;
        this.autoDecrement = false;
        this.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
        LinearLayout.LayoutParams elementParams = new LinearLayout.LayoutParams(this.ELEMENT_HEIGHT, this.ELEMENT_WIDTH);
        this.initDecrementButton(context);
        this.initValueEditText(context);
        this.initIncrementButton(context);
        if (this.getOrientation() == 1) {
            this.addView((View)this.increment, (ViewGroup.LayoutParams)elementParams);
            this.addView((View)this.valueText, (ViewGroup.LayoutParams)elementParams);
            this.addView((View)this.decrement, (ViewGroup.LayoutParams)elementParams);
        } else {
            this.addView((View)this.decrement, (ViewGroup.LayoutParams)elementParams);
            this.addView((View)this.valueText, (ViewGroup.LayoutParams)elementParams);
            this.addView((View)this.increment, (ViewGroup.LayoutParams)elementParams);
        }
        this.valueText.addTextChangedListener(new TextWatcher(){

            public void onTextChanged(CharSequence s, int start, int before, int count) {
                int oldValue = NumberPicker.this.getValue();
                int newValue = !TextUtils.isEmpty((CharSequence)s) ? Integer.valueOf(s.toString()) : 0;
                NumberPicker.this.mValueListener.onValueChange(NumberPicker.this, oldValue, newValue);
            }

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void afterTextChanged(Editable s) {
            }
        });
    }

    private void initIncrementButton(Context context) {
        this.increment = new Button(context);
        this.increment.setTextSize(2, 25.0f);
        this.increment.setText((CharSequence)"+");
        this.increment.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                NumberPicker.this.increment();
            }
        });
        this.increment.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View arg0) {
                NumberPicker.this.autoIncrement = true;
                NumberPicker.this.repeatUpdateHandler.post((Runnable)new RepetetiveUpdater());
                return false;
            }
        });
        this.increment.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                if (event.getAction() == 1 && NumberPicker.this.autoIncrement) {
                    NumberPicker.this.autoIncrement = false;
                }
                return false;
            }
        });
    }

    private void initValueEditText(Context context) {
        this.value = new Integer(0);
        this.valueText = new EditText(context);
        this.valueText.setTextSize(2, 22.0f);
        InputFilter[] filters = new InputFilter[]{new InputFilter.LengthFilter(String.valueOf(99).length())};
        this.valueText.setFilters(filters);
        this.valueText.setOnKeyListener(new View.OnKeyListener(){

            public boolean onKey(View v, int arg1, KeyEvent event) {
                try {
                    NumberPicker.this.value = Integer.parseInt(((EditText)v).getText().toString());
                }
                catch (NumberFormatException nfe) {
                    NumberPicker.this.value = 0;
                }
                return false;
            }
        });
        this.valueText.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View v, boolean hasFocus) {
                if (hasFocus) {
                    ((EditText)v).selectAll();
                }
            }
        });
        this.valueText.setGravity(17);
        this.valueText.setText((CharSequence)this.value.toString());
        this.valueText.setInputType(2);
    }

    private void initDecrementButton(Context context) {
        this.decrement = new Button(context);
        this.decrement.setTextSize(2, 25.0f);
        this.decrement.setText((CharSequence)"-");
        this.decrement.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                NumberPicker.this.decrement();
            }
        });
        this.decrement.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View arg0) {
                NumberPicker.this.autoDecrement = true;
                NumberPicker.this.repeatUpdateHandler.post((Runnable)new RepetetiveUpdater());
                return false;
            }
        });
        this.decrement.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                if (event.getAction() == 1 && NumberPicker.this.autoDecrement) {
                    NumberPicker.this.autoDecrement = false;
                }
                return false;
            }
        });
    }

    public void increment() {
        if (this.value < 99) {
            this.value = this.value + 1;
            this.valueText.setText((CharSequence)this.value.toString());
        }
    }

    public void decrement() {
        if (this.value > 0) {
            this.value = this.value - 1;
            this.valueText.setText((CharSequence)this.value.toString());
        }
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        if (value > 99) {
            value = 99;
        }
        if (value >= 0) {
            this.value = value;
            this.valueText.setText((CharSequence)this.value.toString());
        }
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState ss = new SavedState(superState);
        ss.value = this.getValue();
        return ss;
    }

    public void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof SavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.setValue(ss.value);
    }

    public void setEnabled(boolean enabled) {
        this.increment.setEnabled(enabled);
        this.valueText.setEnabled(enabled);
        this.decrement.setEnabled(enabled);
    }

    public void setOnValueChangeListener(OnValueChangeListener listener) {
        this.mValueListener = listener;
    }

    public static interface OnValueChangeListener {
        public void onValueChange(NumberPicker var1, int var2, int var3);
    }

    static class SavedState
    extends View.BaseSavedState {
        int value;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            this.value = in.readInt();
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeInt(this.value);
        }
    }

    class RepetetiveUpdater
    implements Runnable {
        RepetetiveUpdater() {
        }

        @Override
        public void run() {
            if (NumberPicker.this.autoIncrement) {
                NumberPicker.this.increment();
                NumberPicker.this.repeatUpdateHandler.postDelayed((Runnable)new RepetetiveUpdater(), 50L);
            } else if (NumberPicker.this.autoDecrement) {
                NumberPicker.this.decrement();
                NumberPicker.this.repeatUpdateHandler.postDelayed((Runnable)new RepetetiveUpdater(), 50L);
            }
        }
    }
}

