/*
 * Decompiled with CFR 0.152.
 */
package th.or.nectec.android.library.widget;

import android.content.Context;
import android.content.res.Resources;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import th.or.nectec.android.library.R;
import th.or.nectec.android.library.util.NumberEditTextUtils;
import th.or.nectec.android.library.util.RaiToSqMeterConvertor;
import th.or.nectec.android.library.widget.ClearableEditText;

public class LandAreaEditText
extends LinearLayout {
    Resources mResources;
    ClearableEditText mRaiEditText;
    ClearableEditText mNganEditText;
    ClearableEditText mTarangwaEditText;
    TextWatcher mTxtWatcher;
    OnAreaChangeListener mListener;

    public LandAreaEditText(Context context) {
        this(context, null);
    }

    public LandAreaEditText(Context context, AttributeSet attrs) {
        this(context, attrs, 16842884);
    }

    public LandAreaEditText(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        this.setGravity(16);
        LinearLayout.LayoutParams editTextParam = new LinearLayout.LayoutParams(-2, -1, 1.0f);
        LinearLayout.LayoutParams labelParam = new LinearLayout.LayoutParams(-2, -2);
        this.mRaiEditText = new ClearableEditText(context);
        this.mNganEditText = new ClearableEditText(context);
        this.mTarangwaEditText = new ClearableEditText(context);
        this.mRaiEditText.setInputType(2);
        this.mNganEditText.setInputType(2);
        this.mTarangwaEditText.setInputType(2);
        TextView raiTxtView = new TextView(context, attrs);
        TextView nganTxtView = new TextView(context, attrs);
        TextView tarangwaTxtView = new TextView(context, attrs);
        raiTxtView.setText(R.string.rai);
        nganTxtView.setText(R.string.ngan);
        tarangwaTxtView.setText(R.string.tarangwa);
        this.addView((View)this.mRaiEditText, (ViewGroup.LayoutParams)editTextParam);
        this.addView((View)raiTxtView, (ViewGroup.LayoutParams)labelParam);
        this.addView((View)this.mNganEditText, (ViewGroup.LayoutParams)editTextParam);
        this.addView((View)nganTxtView, (ViewGroup.LayoutParams)labelParam);
        this.addView((View)this.mTarangwaEditText, (ViewGroup.LayoutParams)editTextParam);
        this.addView((View)tarangwaTxtView, (ViewGroup.LayoutParams)labelParam);
        float minSize = TypedValue.applyDimension((int)1, (float)46.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        this.setMinimumHeight((int)minSize);
        this.mTxtWatcher = new TextWatcher(){

            public void onTextChanged(CharSequence s, int start, int before, int count) {
                if (LandAreaEditText.this.mListener != null) {
                    LandAreaEditText.this.mListener.onAreaChange(LandAreaEditText.this.getArea());
                }
            }

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void afterTextChanged(Editable s) {
            }
        };
        this.mRaiEditText.addTextChangedListener(this.mTxtWatcher);
        this.mNganEditText.addTextChangedListener(this.mTxtWatcher);
        this.mTarangwaEditText.addTextChangedListener(this.mTxtWatcher);
    }

    public double getArea() {
        int rai = NumberEditTextUtils.getInt(this.mRaiEditText);
        int ngan = NumberEditTextUtils.getInt(this.mNganEditText);
        int tarangwa = NumberEditTextUtils.getInt(this.mTarangwaEditText);
        return RaiToSqMeterConvertor.RaiToSqMeter(rai, ngan, tarangwa);
    }

    public void setArea(int areaSqM) {
        int rai = RaiToSqMeterConvertor.sqMeterToRai(areaSqM);
        int ngan = RaiToSqMeterConvertor.sqMeterToNgan(areaSqM);
        int tarangwa = RaiToSqMeterConvertor.sqMeterToTarangwa(areaSqM);
        String raiStr = rai > 0 ? String.valueOf(rai) : "";
        String nganStr = ngan > 0 ? String.valueOf(ngan) : "";
        String tarangwaStr = tarangwa > 0 ? String.valueOf(tarangwa) : "";
        this.mRaiEditText.setText(raiStr);
        this.mNganEditText.setText(nganStr);
        this.mTarangwaEditText.setText(tarangwaStr);
    }

    public void setArea(int rai, int ngan, int tarangwa) {
        String raiStr = rai > 0 ? String.valueOf(rai) : "";
        String nganStr = ngan > 0 ? String.valueOf(ngan) : "";
        String tarangwaStr = tarangwa > 0 ? String.valueOf(tarangwa) : "";
        this.mRaiEditText.setText(raiStr);
        this.mNganEditText.setText(nganStr);
        this.mTarangwaEditText.setText(tarangwaStr);
    }

    public void setAreaHint(int areaSqM) {
        int rai = RaiToSqMeterConvertor.sqMeterToRai(areaSqM);
        int ngan = RaiToSqMeterConvertor.sqMeterToNgan(areaSqM);
        int tarangwa = RaiToSqMeterConvertor.sqMeterToTarangwa(areaSqM);
        String raiStr = rai > 0 ? String.valueOf(rai) : "";
        String nganStr = ngan > 0 ? String.valueOf(ngan) : "";
        String tarangwaStr = tarangwa > 0 ? String.valueOf(tarangwa) : "";
        this.mRaiEditText.setHint(raiStr);
        this.mNganEditText.setHint(nganStr);
        this.mTarangwaEditText.setHint(tarangwaStr);
    }

    public int getRai() {
        return NumberEditTextUtils.getInt(this.mRaiEditText);
    }

    public int getNgan() {
        return NumberEditTextUtils.getInt(this.mNganEditText);
    }

    public int gettarangwa() {
        return NumberEditTextUtils.getInt(this.mTarangwaEditText);
    }

    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        Log.d((String)"area", (String)(this.getRai() + "/" + this.getNgan() + "/" + this.gettarangwa()));
        SavedState ss = new SavedState(superState);
        ss.rai = this.getRai();
        ss.ngan = this.getNgan();
        ss.tarangwa = this.gettarangwa();
        return ss;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof SavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.setArea(ss.rai, ss.ngan, ss.tarangwa);
    }

    public void setEnabled(boolean enabled) {
        this.mRaiEditText.setEnabled(enabled);
        this.mNganEditText.setEnabled(enabled);
        this.mTarangwaEditText.setEnabled(enabled);
    }

    public void setOnAreaChangeListener(OnAreaChangeListener listener) {
        this.mListener = listener;
    }

    public static interface OnAreaChangeListener {
        public void onAreaChange(double var1);
    }

    static class SavedState
    extends View.BaseSavedState {
        int rai;
        int ngan;
        int tarangwa;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            this.rai = in.readInt();
            this.ngan = in.readInt();
            this.tarangwa = in.readInt();
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeInt(this.rai);
            out.writeInt(this.ngan);
            out.writeInt(this.tarangwa);
        }
    }
}

