/*
 * Decompiled with CFR 0.152.
 */
package th.or.nectec.android.library.widget;

import android.content.Context;
import android.database.Cursor;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.TextView;
import th.or.nectec.android.library.R;
import th.or.nectec.android.library.widget.TextViewHighLighter;

public class CursorBaseAdapter
extends BaseAdapter {
    private Context mContext;
    protected Cursor mCursor;
    private String[] mFrom;
    private int[] mTo;
    private int mLayout;
    private String mKeyWord;
    private int mColor;

    public CursorBaseAdapter(Context context, int layout2, Cursor c, String[] from, int[] to) {
        this.mContext = context;
        this.mLayout = layout2;
        this.mCursor = c;
        this.mFrom = from;
        this.mTo = to;
        this.mColor = this.mContext.getResources().getColor(R.color.holo_blue_light);
    }

    public int getCount() {
        if (this.mCursor != null) {
            return this.mCursor.getCount();
        }
        return 0;
    }

    public Object getItem(int arg0) {
        return null;
    }

    public void swapCursor(Cursor c) {
        this.swapCursor(c, null);
    }

    public void swapCursor(Cursor c, String keyWord) {
        this.mKeyWord = keyWord;
        if (!TextUtils.isEmpty((CharSequence)this.mKeyWord)) {
            this.mKeyWord = this.mKeyWord.toLowerCase();
        }
        this.mCursor = c;
        this.notifyDataSetChanged();
    }

    public long getItemId(int position) {
        return position;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        if (convertView == null) {
            LayoutInflater inflater = LayoutInflater.from((Context)this.mContext);
            convertView = inflater.inflate(this.mLayout, null);
        }
        for (int i = 0; i < this.mFrom.length; ++i) {
            TextView tv = (TextView)convertView.findViewById(this.mTo[i]);
            if (tv == null || !this.mCursor.moveToPosition(position)) continue;
            String text = this.mCursor.getString(this.mCursor.getColumnIndex(this.mFrom[i]));
            TextViewHighLighter.highLight(tv, text, this.mKeyWord, this.mColor);
        }
        return convertView;
    }
}

