/*
 * Decompiled with CFR 0.152.
 */
package th.or.nectec.android.library.util;

import android.content.Context;
import android.widget.Toast;
import th.or.nectec.android.library.util.Log;

public class TwiceBackPressed {
    public static final int DURATION_SHORT = 0;
    public static final int DURATION_LONG = 1;
    private static final int TIMEOUT_SHORT = 2500;
    private static final int TIMEOUT_LONG = 4000;
    int mTimeout = 2500;
    int mDelay = 500;
    long time1 = 0L;
    long time2 = 0L;
    String mMessage = "\u0e01\u0e23\u0e38\u0e13\u0e32\u0e01\u0e14\u0e2d\u0e35\u0e01\u0e04\u0e23\u0e31\u0e49\u0e07\u0e40\u0e1e\u0e37\u0e48\u0e2d\u0e2d\u0e2d\u0e01";
    Context mContext;

    public TwiceBackPressed(Context context) {
        this.mContext = context;
    }

    public void setToastDuration(int duration) {
        switch (duration) {
            case 1: {
                this.mTimeout = 4000;
                break;
            }
            default: {
                this.mTimeout = 2500;
            }
        }
    }

    public void setToastMessage(String message) {
        this.mMessage = message;
    }

    public void setToastMessage(int stringResource) {
        this.mMessage = this.mContext.getResources().getString(stringResource);
    }

    public boolean onTwiceBackPressed() {
        if (this.time1 == 0L) {
            this.time1 = System.currentTimeMillis();
            int toastTimeOut = this.mTimeout == 2500 ? 0 : 1;
            Toast.makeText((Context)this.mContext, (CharSequence)this.mMessage, (int)toastTimeOut).show();
            return false;
        }
        this.time2 = System.currentTimeMillis();
        long duration = this.time2 - this.time1;
        if (duration < (long)this.mDelay) {
            Log.d("FAIL", "double press delay timeout (delay " + duration + "/" + this.mDelay + " ms)");
            return false;
        }
        if (duration < (long)this.mTimeout) {
            Log.d("SUCCESS", "double press success (duration " + duration + ")");
            return true;
        }
        Log.d("FAIL", "double press timeout (timeout " + duration + "/" + this.mTimeout + " ms)");
        this.time1 = 0L;
        this.time2 = 0L;
        this.onTwiceBackPressed();
        return false;
    }
}

