/*
 * Decompiled with CFR 0.152.
 */
package th.or.nectec.android.library.util;

import android.content.ContentValues;
import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteOpenHelper;
import android.net.Uri;
import android.os.AsyncTask;
import android.text.TextUtils;
import android.util.Log;
import android.widget.ProgressBar;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONInsertOrUpdateTask
extends AsyncTask<Params, Integer, String> {
    public static final String TAG = "JSONInsertTask";
    JSONObject mSQL;
    ProgressBar mProgress;
    OnFinishListener mListener;
    Context mContext;
    SQLiteOpenHelper mDbHelper;
    public static final int CURRENT_VERSION = 2;
    int mVersion = 1;

    public JSONInsertOrUpdateTask(Context context, SQLiteOpenHelper dbHelper, JSONObject sql, ProgressBar progress, OnFinishListener listener) {
        this.mContext = context;
        this.mSQL = sql;
        this.mDbHelper = dbHelper;
        this.mProgress = progress;
        this.mListener = listener;
    }

    public void update() {
        this.mVersion = 2;
    }

    protected String doInBackground(Params ... params) {
        int i = 0;
        int lenght = params.length;
        try {
            SQLiteDatabase db = this.mDbHelper.getWritableDatabase();
            String table = "";
            for (Params p : params) {
                table = table + p.tablename + " ";
                this.createTable(db, this.mSQL, p.uri, p.tablename, p.intColumn, p.strColumn, p.whereCause, p.argsColumn, p.addCol, p.addValue);
                ++i;
            }
            db.close();
            return table.trim();
        }
        catch (SQLiteException sqlex) {
            sqlex.printStackTrace();
            return null;
        }
        catch (NullPointerException nex) {
            nex.printStackTrace();
            return null;
        }
    }

    public void createTable(SQLiteDatabase db, JSONObject sql, Uri uri, String tablename, String[] intColumn, String[] strColumn, String whereClause, String[] argsColumn, String addCol, String addValue) {
        try {
            JSONArray table;
            switch (this.mVersion) {
                case 2: {
                    table = sql.optJSONObject(tablename).optJSONArray("data");
                    break;
                }
                default: {
                    table = sql.optJSONArray(tablename);
                }
            }
            if (table == null) {
                return;
            }
            int max = table.length();
            Log.d((String)TAG, (String)("record=" + max));
            this.publishProgress(new Integer[]{0, max});
            db.beginTransaction();
            for (int i = 0; i < max; ++i) {
                JSONObject record = table.getJSONObject(i);
                ContentValues cv = new ContentValues();
                if (intColumn != null) {
                    for (String col : intColumn) {
                        int v = record.optInt(col, -99);
                        if (v == -99) continue;
                        cv.put(col, Integer.valueOf(v));
                    }
                }
                if (strColumn != null) {
                    for (String col : strColumn) {
                        String v = record.optString(col);
                        if (!TextUtils.isEmpty((CharSequence)v) && !v.equalsIgnoreCase("null")) {
                            cv.put(col, v);
                            continue;
                        }
                        if (!v.equalsIgnoreCase("null")) continue;
                        cv.put(col, "");
                    }
                }
                if (!TextUtils.isEmpty((CharSequence)addCol)) {
                    cv.put(addCol, addValue);
                }
                String[] whereArgs = new String[argsColumn.length];
                for (int w = 0; w < argsColumn.length; ++w) {
                    whereArgs[w] = record.optString(argsColumn[w]);
                }
                int affected = db.update(tablename, cv, whereClause, whereArgs);
                if (affected < 1) {
                    db.insert(tablename, null, cv);
                }
                this.publishProgress(new Integer[]{i * 100 / max, max});
            }
            db.setTransactionSuccessful();
            db.endTransaction();
            this.mContext.getContentResolver().notifyChange(uri, null);
            Log.d((String)TAG, (String)("Json Inserted or updated table " + tablename));
        }
        catch (JSONException ex) {
            Log.e((String)TAG, (String)("error while createTable " + tablename));
            ex.printStackTrace();
        }
        catch (NullPointerException n) {
            Log.e((String)TAG, (String)("null error while createTable " + tablename));
            n.printStackTrace();
        }
    }

    protected void onProgressUpdate(Integer ... values) {
        super.onProgressUpdate((Object[])values);
        if (this.mProgress != null) {
            this.mProgress.setMax(values[1].intValue());
            this.mProgress.setProgress(values[0].intValue());
        }
    }

    protected void onPostExecute(String result) {
        super.onPostExecute((Object)result);
        this.mSQL = null;
        this.mProgress = null;
        if (this.mListener != null) {
            this.mListener.onTaskFinish(result);
        }
        this.mListener = null;
        this.mContext = null;
    }

    public static interface OnFinishListener {
        public void onTaskFinish(String var1);
    }

    public static class Params {
        public Uri uri;
        public String tablename;
        public String[] intColumn;
        public String[] strColumn;
        public String whereCause;
        public String[] argsColumn;
        private String addCol;
        private String addValue;

        public void setAdditionalValue(String col, String value) {
            if (!TextUtils.isEmpty((CharSequence)col) && !TextUtils.isEmpty((CharSequence)value)) {
                this.addCol = col;
                this.addValue = value;
            }
        }
    }
}

