/*
 * Decompiled with CFR 0.152.
 */
package th.or.nectec.android.library.util;

import android.content.ContentResolver;
import android.content.Context;
import android.content.SharedPreferences;
import android.provider.Settings;
import java.io.UnsupportedEncodingException;
import java.util.UUID;

public class DeviceUUIDFactory {
    protected static final String PREFS_FILE = "device_id.xml";
    protected static final String PREFS_DEVICE_ID = "device_id";
    protected static volatile UUID uuid;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DeviceUUIDFactory(Context context) {
        if (uuid != null) return;
        Class<DeviceUUIDFactory> clazz = DeviceUUIDFactory.class;
        synchronized (DeviceUUIDFactory.class) {
            if (uuid != null) return;
            SharedPreferences prefs = context.getSharedPreferences(PREFS_FILE, 0);
            String id2 = prefs.getString(PREFS_DEVICE_ID, null);
            if (id2 != null) {
                uuid = UUID.fromString(id2);
            } else {
                String androidId = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
                try {
                    uuid = !"9774d56d682e549c".equals(androidId) ? UUID.nameUUIDFromBytes(androidId.getBytes("utf8")) : UUID.randomUUID();
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
                prefs.edit().putString(PREFS_DEVICE_ID, uuid.toString()).commit();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public UUID getDeviceUUID() {
        return uuid;
    }

    public static UUID getUUID(Context context) {
        DeviceUUIDFactory devUuidFac = new DeviceUUIDFactory(context);
        return devUuidFac.getDeviceUUID();
    }
}

