/*
 * Decompiled with CFR 0.152.
 */
package th.or.nectec.android.library.util;

import android.text.TextUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import th.or.nectec.android.library.util.AgeCalculator;
import th.or.nectec.android.library.util.LeapDay;

public class DateTime
implements Comparable<DateTime> {
    private static final int[] mDayOfMonth = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static final String[] mThaiMonthArray = new String[]{"\u0e21\u0e01\u0e23\u0e32\u0e04\u0e21", "\u0e01\u0e38\u0e21\u0e20\u0e32\u0e1e\u0e31\u0e19\u0e18\u0e4c", "\u0e21\u0e35\u0e19\u0e32\u0e04\u0e21", "\u0e40\u0e21\u0e29\u0e32\u0e22\u0e19", "\u0e1e\u0e24\u0e29\u0e20\u0e32\u0e04\u0e21", "\u0e21\u0e34\u0e16\u0e38\u0e19\u0e32\u0e22\u0e19", "\u0e01\u0e23\u0e01\u0e0e\u0e32\u0e04\u0e21", "\u0e2a\u0e34\u0e07\u0e2b\u0e32\u0e04\u0e21", "\u0e01\u0e31\u0e19\u0e22\u0e32\u0e22\u0e19", "\u0e15\u0e38\u0e25\u0e32\u0e04\u0e21", "\u0e1e\u0e24\u0e28\u0e08\u0e34\u0e01\u0e32\u0e22\u0e19", "\u0e18\u0e31\u0e19\u0e27\u0e32\u0e04\u0e21"};
    private static final String[] mEngMonthArray = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
    public int year = 0;
    public int month = 0;
    public int day = 0;
    public int hour = 0;
    public int minute = 0;
    public int second = 0;
    public static final int NEWER = 1;
    public static final int OLDER = -1;
    public static final int EQUAL = 0;

    public DateTime(int year, int month, int day) {
        this.year = year;
        this.month = month;
        this.day = day;
    }

    public DateTime(int year, int month, int day, int hour, int minute, int second) {
        this(year, month, day);
        this.hour = hour;
        this.minute = minute;
        this.second = second;
    }

    public DateTime() {
        this.year = 0;
        this.month = 0;
        this.day = 0;
    }

    public static String getCurrentDate() {
        try {
            Calendar current = Calendar.getInstance();
            int currentYear = current.get(1);
            int currentMonth = current.get(2) + 1;
            int currentDay = current.get(5);
            String month = currentMonth < 10 ? "0" + currentMonth : "" + currentMonth;
            String day = currentDay < 10 ? "0" + currentDay : "" + currentDay;
            return currentYear + "-" + month + "-" + day;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "";
        }
    }

    public static String getCurrentTime() {
        try {
            Calendar current = Calendar.getInstance();
            int currentHour = current.get(11);
            int currentMinute = current.get(12);
            int currentSecond = current.get(13);
            String Hour = currentHour < 10 ? "0" + currentHour : "" + currentHour;
            String Minute = currentMinute < 10 ? "0" + currentMinute : "" + currentMinute;
            String Second = currentSecond < 10 ? "0" + currentSecond : "" + currentSecond;
            return Hour + ":" + Minute + ":" + Second;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "";
        }
    }

    public static String getCurrentDateTime() {
        String datetime = DateTime.getCurrentDate() + " " + DateTime.getCurrentTime();
        return datetime;
    }

    private static String getMonthNameThai(int monthIndex) {
        if (monthIndex < 1 || monthIndex > 12) {
            throw new IndexOutOfBoundsException();
        }
        String[] month = mThaiMonthArray;
        return month[monthIndex - 1];
    }

    private static String getMonthName(int monthIndex) {
        if (monthIndex < 1 || monthIndex > 12) {
            throw new IndexOutOfBoundsException();
        }
        String[] month = mEngMonthArray;
        return month[monthIndex - 1];
    }

    public static String getFullFormatThai(String date) {
        DateTime d = DateTime.newInstance(date);
        return DateTime.getFullFormatThai(d);
    }

    public static String getFullFormatThai(DateTime d) {
        if (d != null) {
            return d.day + " " + DateTime.getMonthNameThai(d.month) + " " + (d.year + 543);
        }
        return null;
    }

    public static String getFullFormat(DateTime d) {
        if (d != null) {
            return d.year + " " + DateTime.getMonthName(d.month) + " " + d.day;
        }
        return null;
    }

    public String getDatetimeAgo() {
        DateTime current = DateTime.newInstance(DateTime.getCurrentDateTime());
        if (this.compareTo(current) != -1) {
            return null;
        }
        DateTime distance = new AgeCalculator(current, this).calulate();
        int dist = 0;
        dist += distance.year * 365;
        dist += distance.month * 30;
        if ((dist += distance.day) == 0) {
            long currentUnix = DateTime.dateTimeToUnix(current.toString());
            long thisUnix = DateTime.dateTimeToUnix(this.toString());
            DateTime timeAgo = this.secToDateTime(currentUnix - thisUnix);
            if (timeAgo.hour > 0) {
                return timeAgo.hour + " \u0e0a\u0e31\u0e48\u0e27\u0e42\u0e21\u0e07";
            }
            if (timeAgo.minute > 0) {
                return timeAgo.minute + " \u0e19\u0e32\u0e17\u0e35";
            }
            return timeAgo.second + " \u0e27\u0e34\u0e19\u0e32\u0e17\u0e35";
        }
        if (dist == 1) {
            return "\u0e40\u0e21\u0e37\u0e48\u0e2d\u0e27\u0e32\u0e19";
        }
        String thFormat = DateTime.getFullFormatThai(this);
        if (this.year == current.year) {
            thFormat = thFormat.substring(0, thFormat.length() - 4);
        }
        return thFormat;
    }

    private DateTime secToDateTime(long sec) {
        DateTime d = new DateTime();
        d.hour = (int)sec / 3600;
        int remainder = (int)sec - d.hour * 3600;
        d.minute = remainder / 60;
        d.second = remainder -= d.minute * 60;
        return d;
    }

    private static long dateTimeToUnix(String dt) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-mm-dd HH:mm:ss", new Locale("th", "TH"));
        Date date = null;
        try {
            date = format.parse(dt);
            return date.getTime() / 1000L;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public String toString() {
        String month = this.month < 10 ? "0" + this.month : "" + this.month;
        String day = this.day < 10 ? "0" + this.day : "" + this.day;
        String hour = this.hour < 10 ? "0" + this.hour : "" + this.hour;
        String minute = this.minute < 10 ? "0" + this.minute : "" + this.minute;
        String second = this.second < 10 ? "0" + this.second : "" + this.second;
        String dateString = this.year + "-" + month + "-" + day;
        String timeString = hour + ":" + minute + ":" + second;
        String returnString = !timeString.equals("00:00:00") ? dateString + " " + timeString : dateString;
        return returnString;
    }

    public static DateTime newInstance(String date) {
        if (TextUtils.isEmpty((CharSequence)date)) {
            return null;
        }
        int day = Integer.parseInt(date.substring(8, 10));
        int month = Integer.parseInt(date.substring(5, 7));
        int year = Integer.parseInt(date.substring(0, 4));
        if (date.length() >= 18) {
            int second = Integer.parseInt(date.substring(17, 19));
            int minute = Integer.parseInt(date.substring(14, 16));
            int hour = Integer.parseInt(date.substring(11, 13));
            return new DateTime(year, month, day, hour, minute, second);
        }
        return new DateTime(year, month, day);
    }

    public static DateTime newInstance() {
        return DateTime.newInstance(DateTime.getCurrentDateTime());
    }

    public void increaseDay(int day) {
        if (day < 1) {
            throw new IllegalArgumentException("increase day more than 0");
        }
        int leftDay = this.getMaxDayOfMonth() - this.day;
        if (day - leftDay <= 0) {
            this.day += day;
        } else {
            this.day = 0;
            this.increaseMonth(1);
            day -= leftDay;
            while (day - this.getMaxDayOfMonth() > 0) {
                day -= this.getMaxDayOfMonth();
                this.increaseMonth(1);
            }
            this.day += day;
        }
    }

    public void increaseMonth(int month) {
        if (month < 1) {
            throw new IllegalArgumentException("increase month must more than 0");
        }
        int monthIndex = this.month - 1;
        if ((monthIndex += month) > 11) {
            int incYear = monthIndex / 11;
            this.year += incYear;
            monthIndex = (monthIndex - incYear) % 11;
        }
        this.month = monthIndex + 1;
    }

    public int getMaxDayOfMonth() {
        int maxDay = 0;
        maxDay = this.month == 2 ? LeapDay.february(this.year) : mDayOfMonth[this.month - 1];
        return maxDay;
    }

    public int distanceTo(DateTime another) {
        if (this.compareTo(another) != -1) {
            return 0;
        }
        DateTime distance = new AgeCalculator(another, this).calulate();
        int dist = 0;
        dist += distance.year * 365;
        dist += distance.month * 30;
        return dist += distance.day;
    }

    @Override
    public int compareTo(DateTime another) {
        if (this.year == another.year) {
            if (this.month == another.month) {
                if (this.day == another.day) {
                    if (this.hour == another.hour) {
                        if (this.minute == another.minute) {
                            if (this.second == another.second) {
                                return 0;
                            }
                            if (this.second > another.second) {
                                return 1;
                            }
                            return -1;
                        }
                        if (this.minute > another.minute) {
                            return 1;
                        }
                        return -1;
                    }
                    if (this.hour > another.hour) {
                        return 1;
                    }
                    return -1;
                }
                if (this.day > another.day) {
                    return 1;
                }
                return -1;
            }
            if (this.month > another.month) {
                return 1;
            }
            return -1;
        }
        if (this.year > another.year) {
            return 1;
        }
        return -1;
    }
}

