/*
 * Decompiled with CFR 0.152.
 */
package th.or.nectec.android.library.network;

import android.os.AsyncTask;
import android.text.TextUtils;
import android.util.Log;
import android.widget.ProgressBar;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;

public class HttpDownloadTask
extends AsyncTask<DownloadParam, Integer, ArrayList<File>> {
    private ProgressBar mProgress;
    private OnFinishListener mListener;
    private OnProgressUpdateListener mProgressListener;
    int fileCount = 0;

    public HttpDownloadTask(ProgressBar progress, OnFinishListener listener) {
        this.mProgress = progress;
        this.mListener = listener;
    }

    public void setOnProgressUpdateListener(OnProgressUpdateListener listener) {
        this.mProgressListener = listener;
    }

    protected ArrayList<File> doInBackground(DownloadParam ... params) {
        ArrayList<File> successFileList = new ArrayList<File>();
        for (DownloadParam downloadParam : params) {
            this.fileCount = 0;
            int size = downloadParam.urlList.size();
            for (int i = 0; i < size; ++i) {
                ++this.fileCount;
                File success = this.download((String)downloadParam.urlList.get(i), (File)downloadParam.destList.get(i));
                if (success != null) {
                    Log.d((String)"donwload", (String)("success download to " + success.getAbsolutePath()));
                    successFileList.add(success);
                    continue;
                }
                Log.d((String)"donwload", (String)("fail to  download " + (String)downloadParam.urlList.get(i)));
            }
        }
        return successFileList;
    }

    private File download(String urlString, File file) {
        try {
            int count;
            URL url = new URL(urlString);
            URLConnection connection = url.openConnection();
            connection.connect();
            int fileLength = connection.getContentLength();
            if (!file.exists()) {
                file.createNewFile();
            }
            BufferedInputStream input = new BufferedInputStream(url.openStream());
            FileOutputStream output = new FileOutputStream(file);
            byte[] data = new byte[1024];
            long total = 0L;
            while ((count = ((InputStream)input).read(data)) != -1) {
                this.publishProgress(new Integer[]{this.fileCount, 100, (int)((total += (long)count) * 100L / (long)fileLength)});
                ((OutputStream)output).write(data, 0, count);
            }
            output.flush();
            ((OutputStream)output).close();
            ((InputStream)input).close();
            return file;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected void onProgressUpdate(Integer ... values) {
        super.onProgressUpdate((Object[])values);
        if (this.mProgress != null) {
            this.mProgress.setMax(values[1].intValue());
            this.mProgress.setProgress(values[2].intValue());
        }
        if (this.mProgressListener != null) {
            this.mProgressListener.onProgressUpdate(values[0], values[1], values[2]);
        }
    }

    protected void onPostExecute(ArrayList<File> result) {
        super.onPostExecute(result);
        if (this.mListener != null) {
            this.mListener.onTaskFinish(result);
        }
    }

    public static interface OnProgressUpdateListener {
        public void onProgressUpdate(int var1, int var2, int var3);
    }

    public static interface OnFinishListener {
        public void onTaskFinish(ArrayList<File> var1);
    }

    public static class DownloadParam {
        private ArrayList<String> urlList = new ArrayList();
        private ArrayList<File> destList = new ArrayList();

        public void setParam(String url, File destPath) {
            if (TextUtils.isEmpty((CharSequence)url) || destPath != null) {
                return;
            }
            this.urlList.add(url);
            this.destList.add(destPath);
        }

        public void setParam(File folder, ArrayList<String> urlList) {
            if (!folder.isDirectory()) {
                throw new IllegalStateException("must add File object thai is Directory!");
            }
            String directory = folder.getAbsolutePath();
            for (String url : urlList) {
                String filename = url.substring(url.lastIndexOf("/") + 1);
                Log.d((String)"Download", (String)("dir=" + directory + " filename=" + filename));
                this.urlList.add(url);
                this.destList.add(new File(directory, filename));
            }
        }
    }
}

