/*
 * Decompiled with CFR 0.152.
 */
package th.or.nectec.android.library.form.validator;

import android.text.TextUtils;
import android.util.Log;
import th.or.nectec.android.library.form.validator.AbstractValidator;
import th.or.nectec.android.library.form.validator.ValidatorException;
import th.or.nectec.android.library.util.DateTime;

public class DateValidator
extends AbstractValidator {
    DateTime mOldestDate;
    DateTime mNewestDate;
    String mErrMessage;
    public static final String MESSAGE_PAST_DATE = "date can't be in future";
    public static final String MESSAGE_FUTURE_DATE = "date can't be past";

    public DateValidator(DateTime oldestDate, DateTime newestDate, String errorMessage) {
        super(null);
        this.mOldestDate = oldestDate;
        this.mNewestDate = newestDate;
        this.mErrMessage = errorMessage;
    }

    public DateValidator(String oldestDate, String newestDate, String errorMessage) {
        super(null);
        if (!TextUtils.isEmpty((CharSequence)oldestDate)) {
            this.mOldestDate = DateTime.newInstance(oldestDate);
        }
        if (!TextUtils.isEmpty((CharSequence)newestDate)) {
            this.mNewestDate = DateTime.newInstance(newestDate);
        }
        this.mErrMessage = errorMessage;
    }

    public DateTime getOldestDate() {
        return this.mOldestDate;
    }

    public void setOldestDate(DateTime mOldestDate) {
        this.mOldestDate = mOldestDate;
    }

    public DateTime getNewestDate() {
        return this.mNewestDate;
    }

    public void setNewestDate(DateTime mNewestDate) {
        this.mNewestDate = mNewestDate;
    }

    @Override
    public boolean isValid(String value) throws ValidatorException {
        DateTime val = DateTime.newInstance(value);
        boolean valid = true;
        if (this.mNewestDate != null && val.compareTo(this.mNewestDate) > 0) {
            valid = false;
        }
        if (this.mOldestDate != null && val.compareTo(this.mOldestDate) < 0) {
            valid = false;
        }
        return valid;
    }

    @Override
    public String getMessage() {
        return this.mErrMessage;
    }

    public static DateValidator getPastDateValidator() {
        return new DateValidator("1875-01-01", DateTime.getCurrentDate(), MESSAGE_PAST_DATE);
    }

    public static DateValidator getPastDateValidator(DateTime oldestDate, String msg) {
        Log.d((String)"Oldest Date", (String)(oldestDate + ""));
        return new DateValidator(oldestDate.toString(), DateTime.getCurrentDate(), msg);
    }

    public static DateValidator getFutureDateValidator() {
        return new DateValidator(DateTime.getCurrentDate(), null, MESSAGE_FUTURE_DATE);
    }

    public static DateValidator getFutureDateValidator(DateTime newestDate, String msg) {
        return new DateValidator(DateTime.getCurrentDate(), newestDate.toString(), msg);
    }
}

