/*
 * Decompiled with CFR 0.152.
 */
package th.or.nectec.android.library.form.validator;

import android.text.TextUtils;
import th.or.nectec.android.library.form.validator.AbstractValidator;
import th.or.nectec.android.library.form.validator.ValidatorException;
import th.or.nectec.android.library.util.DateTime;
import th.or.nectec.android.library.widget.ThaiDatePicker;

public class DateFieldCompareValidator
extends AbstractValidator {
    int mCompareMode;
    ThaiDatePicker mCompareDateView;
    String mDateValue;
    public static final int BEFORE = 0;
    public static final int AFTER = 1;

    public DateFieldCompareValidator(int mode, ThaiDatePicker compareDate, String errorMessage) {
        super(null);
        this.mCompareMode = mode;
        this.mCompareDateView = compareDate;
        this.mErrorMsg = errorMessage;
    }

    @Override
    public boolean isValid(String value) throws ValidatorException {
        this.mDateValue = value;
        DateTime val = DateTime.newInstance(value);
        switch (this.mCompareMode) {
            case 0: {
                return val.compareTo(this.mCompareDateView.getDate()) >= 0;
            }
            case 1: {
                return val.compareTo(this.mCompareDateView.getDate()) <= 0;
            }
        }
        return true;
    }

    @Override
    public String getMessage() {
        if (!TextUtils.isEmpty((CharSequence)this.mErrorMsg)) {
            return this.mErrorMsg;
        }
        switch (this.mCompareMode) {
            case 0: {
                return DateTime.getFullFormatThai(this.mDateValue) + " \u0e44\u0e21\u0e48\u0e04\u0e27\u0e23\u0e0a\u0e49\u0e32\u0e01\u0e27\u0e48\u0e32\u0e27\u0e31\u0e19\u0e17\u0e35\u0e48  " + DateTime.getFullFormatThai(this.mCompareDateView.getDate());
            }
            case 1: {
                return DateTime.getFullFormatThai(this.mDateValue) + " \u0e44\u0e21\u0e48\u0e04\u0e27\u0e23\u0e40\u0e25\u0e22\u0e27\u0e31\u0e19\u0e17\u0e35\u0e48  " + DateTime.getFullFormatThai(this.mCompareDateView.getDate());
            }
        }
        return "\u0e44\u0e21\u0e48\u0e17\u0e23\u0e32\u0e1a";
    }

    public static DateFieldCompareValidator getBeforeDateValidator(ThaiDatePicker compareDate) {
        return new DateFieldCompareValidator(0, compareDate, null);
    }

    public static DateFieldCompareValidator getBeforeDateValidator(ThaiDatePicker compareDate, String msg) {
        return new DateFieldCompareValidator(0, compareDate, msg);
    }

    public static DateFieldCompareValidator getAfterDateValidator(ThaiDatePicker compareDate) {
        return new DateFieldCompareValidator(1, compareDate, null);
    }

    public static DateFieldCompareValidator getAfterDateValidator(ThaiDatePicker compareDate, String msg) {
        return new DateFieldCompareValidator(1, compareDate, msg);
    }
}

