/*
 * Decompiled with CFR 0.152.
 */
package th.or.nectec.android.library.form.field;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.view.View;
import java.util.ArrayList;
import th.or.nectec.android.library.form.IMultiColumnField;
import th.or.nectec.android.library.form.NTField;
import th.or.nectec.android.library.widget.CheckBoxesGroup;

public class NTMultiChoiceField
extends NTField
implements IMultiColumnField {
    String[] mColumns;
    String[] mChoice;

    public NTMultiChoiceField(CheckBoxesGroup view, String[] column) {
        super((View)view, column[0]);
        this.mColumns = column;
    }

    public NTMultiChoiceField(String[] column, String lable, String[] choice) {
        super(column[0], lable);
        this.mColumns = column;
        this.mChoice = choice;
    }

    @Override
    public String[] getColumns() {
        return this.mColumns;
    }

    @Override
    public void setValueByCursor(Cursor c) {
        CheckBoxesGroup cbg = (CheckBoxesGroup)this.mView;
        cbg.setChecked(false);
        for (String col : this.mColumns) {
            String value = c.getString(c.getColumnIndex(col));
            cbg.setChecked(true, value);
        }
    }

    @Override
    public ContentValues getContentValues() {
        ContentValues cv = new ContentValues();
        ArrayList<String> chkList = ((CheckBoxesGroup)this.mView).getCheckedItem();
        int chkListSize = chkList.size();
        int colLength = this.mColumns.length;
        for (int i = 0; i < colLength && i < chkListSize; ++i) {
            cv.put(this.mColumns[i], chkList.get(i));
        }
        return cv;
    }

    @Override
    @Deprecated
    public String getValue() {
        return null;
    }

    @Override
    @Deprecated
    public void setValue(String value) {
    }

    @Override
    public View onCreateView(Context context) {
        CheckBoxesGroup cbg = new CheckBoxesGroup(context, null);
        cbg.setMode(2);
        cbg.setArray(this.mChoice);
        return cbg;
    }
}

