/*
 * Decompiled with CFR 0.152.
 */
package th.or.nectec.android.library.form.field;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.text.TextUtils;
import android.view.View;
import java.util.ArrayList;
import th.or.nectec.android.library.form.IMultiColumnField;
import th.or.nectec.android.library.form.NTField;
import th.or.nectec.android.library.util.StringUtils;
import th.or.nectec.android.library.widget.CheckBoxesGroup;

public class NTCheckListField
extends NTField
implements IMultiColumnField {
    String[] mColumns;
    String[] mChoice;
    String mCheckedValue = "1";
    String mNotCheckedValue = "0";
    public static final String[] CheckedValue = new String[]{"yes", "true", "1"};
    public static final String[] UncheckedValue = new String[]{"no", "false", "0"};

    public NTCheckListField(CheckBoxesGroup view, String[] Column) {
        super((View)view, Column[0]);
        this.mColumns = Column;
    }

    public NTCheckListField(CheckBoxesGroup view, String checkedValue, String notCheckValue, String[] column) {
        super((View)view, column[0]);
        this.mColumns = column;
        this.mCheckedValue = checkedValue;
        this.mNotCheckedValue = notCheckValue;
    }

    public NTCheckListField(String[] column, String label, String[] choice) {
        super(column[0], label);
        this.mColumns = column;
        this.mChoice = choice;
    }

    public NTCheckListField(String[] column, String label, String[] choice, String checkedValue, String notCheckValue) {
        super(column[0], label);
        this.mColumns = column;
        this.mChoice = choice;
        this.mCheckedValue = checkedValue;
        this.mNotCheckedValue = notCheckValue;
    }

    @Override
    public String[] getColumns() {
        return this.mColumns;
    }

    @Override
    public void setValueByCursor(Cursor c) {
        CheckBoxesGroup cbg = (CheckBoxesGroup)this.mView;
        cbg.setChecked(false);
        for (String col : this.mColumns) {
            String value = c.getString(c.getColumnIndex(col));
            if (!TextUtils.isEmpty((CharSequence)value) && StringUtils.isEqualIgnoreCase(value, this.mCheckedValue)) {
                cbg.setChecked(true, value);
                continue;
            }
            cbg.setChecked(false, value);
        }
    }

    @Override
    public ContentValues getContentValues() {
        ContentValues cv = new ContentValues();
        ArrayList<String> chkList = ((CheckBoxesGroup)this.mView).getCheckedItem();
        int chkListSize = chkList.size();
        int colLength = this.mColumns.length;
        String[] chkListArray = chkList.toArray(new String[chkListSize]);
        for (int i = 0; i < colLength; ++i) {
            String col = this.mColumns[i];
            if (StringUtils.isEqualIgnoreCase(col, chkListArray)) {
                cv.put(col, this.mCheckedValue);
                continue;
            }
            cv.put(col, this.mNotCheckedValue);
        }
        return cv;
    }

    @Override
    @Deprecated
    public String getValue() {
        return null;
    }

    @Override
    @Deprecated
    public void setValue(String value) {
    }

    @Override
    public View onCreateView(Context context) {
        CheckBoxesGroup cbg = new CheckBoxesGroup(context, null);
        cbg.setMode(2);
        cbg.setArray(this.mChoice);
        return cbg;
    }
}

