/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.plotting.fx;

import java.util.ArrayList;
import javafx.collections.FXCollections;
import javafx.scene.chart.Axis;
import javafx.scene.chart.BarChart;
import javafx.scene.chart.CategoryAxis;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.XYChart;
import javafx.scene.layout.Background;
import tech.tablesaw.api.CategoryColumn;
import tech.tablesaw.api.IntColumn;
import tech.tablesaw.api.NumericColumn;
import tech.tablesaw.api.ShortColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.Column;
import tech.tablesaw.plotting.fx.FxBuilder;

public class FxPareto
extends FxBuilder {
    public static BarChart<String, Number> chart(String title, CategoryColumn x, NumericColumn y) {
        CategoryAxis xAxis = new CategoryAxis();
        NumberAxis yAxis = new NumberAxis();
        xAxis.setLabel(x.name());
        yAxis.setLabel(y.name());
        Table t = Table.create((String)"", (Column[])new Column[]{x, y});
        t = t.sortDescendingOn(new String[]{y.name()});
        BarChart bar = new BarChart((Axis)xAxis, (Axis)yAxis);
        bar.setTitle(title);
        ArrayList<XYChart.Data> d2 = new ArrayList<XYChart.Data>(x.size());
        for (int i = 0; i < x.size(); ++i) {
            d2.add(new XYChart.Data((Object)t.categoryColumn(0).get(i), (Object)Float.valueOf(t.nCol(1).getFloat(i))));
        }
        XYChart.Series series1 = new XYChart.Series(FXCollections.observableList(d2));
        series1.setName(y.name());
        bar.setLegendVisible(false);
        bar.setCategoryGap(0.0);
        bar.setBarGap(0.1);
        bar.setBackground(Background.EMPTY);
        bar.setVerticalGridLinesVisible(false);
        bar.getData().addAll((Object[])new XYChart.Series[]{series1});
        return bar;
    }

    public static BarChart<String, Number> chart(String title, IntColumn categoryColumn, NumericColumn numericColumn) {
        Table t = Table.create((String)"", (Column[])new Column[]{categoryColumn, numericColumn});
        t = t.sortDescendingOn(new String[]{numericColumn.name()});
        CategoryAxis categoryAxis = FxPareto.getCategoryAxis((Column)t.categoryColumn(0));
        NumberAxis numberAxis = FxPareto.getNumberAxis(t.numericColumn(1));
        BarChart<String, Number> barChart = FxPareto.getBarChart(title, categoryAxis, numberAxis);
        ArrayList<XYChart.Data<String, Number>> data = new ArrayList<XYChart.Data<String, Number>>(categoryColumn.size());
        for (int i = 0; i < categoryColumn.size(); ++i) {
            data.add((XYChart.Data<String, Number>)new XYChart.Data((Object)categoryColumn.getString(i), (Object)Float.valueOf(numericColumn.getFloat(i))));
        }
        barChart.getData().addAll((Object[])new XYChart.Series[]{FxPareto.getSeries(numericColumn, data)});
        return barChart;
    }

    public static BarChart<String, Number> chart(String title, ShortColumn categoryColumn, NumericColumn numericColumn) {
        Table t = Table.create((String)"", (Column[])new Column[]{categoryColumn, numericColumn});
        t = t.sortDescendingOn(new String[]{numericColumn.name()});
        CategoryAxis categoryAxis = FxPareto.getCategoryAxis((Column)t.categoryColumn(0));
        NumberAxis numberAxis = FxPareto.getNumberAxis(t.numericColumn(1));
        BarChart<String, Number> barChart = FxPareto.getBarChart(title, categoryAxis, numberAxis);
        ArrayList<XYChart.Data<String, Number>> data = new ArrayList<XYChart.Data<String, Number>>(categoryColumn.size());
        for (int i = 0; i < categoryColumn.size(); ++i) {
            data.add((XYChart.Data<String, Number>)new XYChart.Data((Object)categoryColumn.getString(i), (Object)Float.valueOf(numericColumn.getFloat(i))));
        }
        barChart.getData().addAll((Object[])new XYChart.Series[]{FxPareto.getSeries(numericColumn, data)});
        return barChart;
    }
}

