/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.plotting.fx;

import java.util.ArrayList;
import java.util.List;
import javafx.collections.FXCollections;
import javafx.scene.chart.Axis;
import javafx.scene.chart.BarChart;
import javafx.scene.chart.CategoryAxis;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.XYChart;
import javafx.scene.layout.Background;
import tech.tablesaw.api.NumberColumn;
import tech.tablesaw.api.StringColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.Column;
import tech.tablesaw.plotting.fx.FxBuilder;

public class FxHorizontalBar
extends FxBuilder {
    public static BarChart<Number, String> chart(String title, Table table, String categoryColumnName, String numberColumnName) {
        StringColumn stringColumn = table.stringColumn(categoryColumnName);
        NumberColumn numberColumn = table.nCol(numberColumnName);
        return FxHorizontalBar.chart(title, stringColumn, numberColumn);
    }

    public static BarChart<Number, String> chart(String title, StringColumn stringColumn, NumberColumn numberColumn) {
        CategoryAxis categoryAxis = FxHorizontalBar.getCategoryAxis((Column)stringColumn);
        NumberAxis numberAxis = FxHorizontalBar.getNumberAxis(numberColumn);
        BarChart<Number, String> bar = FxHorizontalBar.getNumberStringBarChart(title, numberAxis, categoryAxis);
        ArrayList<XYChart.Data<Number, String>> d2 = new ArrayList<XYChart.Data<Number, String>>(numberColumn.size());
        for (int i = 0; i < numberColumn.size(); ++i) {
            d2.add((XYChart.Data<Number, String>)new XYChart.Data((Object)numberColumn.get(i), (Object)stringColumn.get(i)));
        }
        XYChart.Series<Number, String> series1 = FxHorizontalBar.getNumberStringSeries((Column)stringColumn, d2);
        bar.getData().add(series1);
        return bar;
    }

    public static BarChart<Number, String> chart(String title, NumberColumn categoryColumn, NumberColumn numberColumn) {
        CategoryAxis categoryAxis = FxHorizontalBar.getCategoryAxis((Column)categoryColumn);
        NumberAxis numberAxis = FxHorizontalBar.getNumberAxis(numberColumn);
        BarChart<Number, String> bar = FxHorizontalBar.getNumberStringBarChart(title, numberAxis, categoryAxis);
        ArrayList<XYChart.Data<Number, String>> d2 = new ArrayList<XYChart.Data<Number, String>>(numberColumn.size());
        for (int i = 0; i < numberColumn.size(); ++i) {
            d2.add((XYChart.Data<Number, String>)new XYChart.Data((Object)numberColumn.get(i), (Object)categoryColumn.getString(i)));
        }
        XYChart.Series<Number, String> series1 = FxHorizontalBar.getNumberStringSeries((Column)categoryColumn, d2);
        bar.getData().add(series1);
        return bar;
    }

    private static XYChart.Series<Number, String> getNumberStringSeries(Column categoryColumn, List<XYChart.Data<Number, String>> d2) {
        XYChart.Series series1 = new XYChart.Series(FXCollections.observableList(d2));
        series1.setName(categoryColumn.name());
        return series1;
    }

    private static BarChart<Number, String> getNumberStringBarChart(String title, NumberAxis xAxis, CategoryAxis yAxis) {
        BarChart bar = new BarChart((Axis)xAxis, (Axis)yAxis);
        bar.setTitle(title);
        bar.setLegendVisible(false);
        bar.setCategoryGap(0.0);
        bar.setBarGap(0.25);
        bar.setBackground(Background.EMPTY);
        bar.setHorizontalGridLinesVisible(false);
        return bar;
    }
}

