/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.plotting.fx;

import java.util.ArrayList;
import java.util.List;
import javafx.collections.FXCollections;
import javafx.scene.chart.Axis;
import javafx.scene.chart.BarChart;
import javafx.scene.chart.CategoryAxis;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.XYChart;
import javafx.scene.layout.Background;
import tech.tablesaw.api.CategoryColumn;
import tech.tablesaw.api.IntColumn;
import tech.tablesaw.api.NumericColumn;
import tech.tablesaw.api.ShortColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.Column;
import tech.tablesaw.plotting.fx.FxBuilder;

public class FxHorizontalBar
extends FxBuilder {
    public static BarChart<Number, String> chart(String title, Table table, String categoryColumnName, String numericColumnName) {
        CategoryColumn categoryColumn = table.categoryColumn(categoryColumnName);
        NumericColumn numericColumn = table.nCol(numericColumnName);
        return FxHorizontalBar.chart(title, categoryColumn, numericColumn);
    }

    public static BarChart<Number, String> chart(String title, CategoryColumn categoryColumn, NumericColumn numericColumn) {
        CategoryAxis categoryAxis = FxHorizontalBar.getCategoryAxis((Column)categoryColumn);
        NumberAxis numberAxis = FxHorizontalBar.getNumberAxis(numericColumn);
        BarChart<Number, String> bar = FxHorizontalBar.getNumberStringBarChart(title, numberAxis, categoryAxis);
        ArrayList<XYChart.Data<Number, String>> d2 = new ArrayList<XYChart.Data<Number, String>>(numericColumn.size());
        for (int i = 0; i < numericColumn.size(); ++i) {
            d2.add((XYChart.Data<Number, String>)new XYChart.Data((Object)numericColumn.getDouble(i), (Object)categoryColumn.get(i)));
        }
        XYChart.Series<Number, String> series1 = FxHorizontalBar.getNumberStringSeries((Column)categoryColumn, d2);
        bar.getData().add(series1);
        return bar;
    }

    public static BarChart<Number, String> chart(String title, ShortColumn categoryColumn, NumericColumn numericColumn) {
        CategoryAxis categoryAxis = FxHorizontalBar.getCategoryAxis((Column)categoryColumn);
        NumberAxis numberAxis = FxHorizontalBar.getNumberAxis(numericColumn);
        BarChart<Number, String> bar = FxHorizontalBar.getNumberStringBarChart(title, numberAxis, categoryAxis);
        ArrayList<XYChart.Data<Number, String>> d2 = new ArrayList<XYChart.Data<Number, String>>(numericColumn.size());
        for (int i = 0; i < numericColumn.size(); ++i) {
            d2.add((XYChart.Data<Number, String>)new XYChart.Data((Object)numericColumn.getDouble(i), (Object)categoryColumn.getString(i)));
        }
        XYChart.Series<Number, String> series1 = FxHorizontalBar.getNumberStringSeries((Column)categoryColumn, d2);
        bar.getData().add(series1);
        return bar;
    }

    public static BarChart<Number, String> chart(String title, IntColumn categoryColumn, NumericColumn numericColumn) {
        CategoryAxis categoryAxis = FxHorizontalBar.getCategoryAxis((Column)categoryColumn);
        NumberAxis numberAxis = FxHorizontalBar.getNumberAxis(numericColumn);
        BarChart<Number, String> bar = FxHorizontalBar.getNumberStringBarChart(title, numberAxis, categoryAxis);
        ArrayList<XYChart.Data<Number, String>> d2 = new ArrayList<XYChart.Data<Number, String>>(numericColumn.size());
        for (int i = 0; i < numericColumn.size(); ++i) {
            d2.add((XYChart.Data<Number, String>)new XYChart.Data((Object)numericColumn.getDouble(i), (Object)categoryColumn.getString(i)));
        }
        XYChart.Series<Number, String> series1 = FxHorizontalBar.getNumberStringSeries((Column)categoryColumn, d2);
        bar.getData().add(series1);
        return bar;
    }

    private static XYChart.Series<Number, String> getNumberStringSeries(Column categoryColumn, List<XYChart.Data<Number, String>> d2) {
        XYChart.Series series1 = new XYChart.Series(FXCollections.observableList(d2));
        series1.setName(categoryColumn.name());
        return series1;
    }

    private static BarChart<Number, String> getNumberStringBarChart(String title, NumberAxis xAxis, CategoryAxis yAxis) {
        BarChart bar = new BarChart((Axis)xAxis, (Axis)yAxis);
        bar.setTitle(title);
        bar.setLegendVisible(false);
        bar.setCategoryGap(0.0);
        bar.setBarGap(0.25);
        bar.setBackground(Background.EMPTY);
        bar.setHorizontalGridLinesVisible(false);
        return bar;
    }
}

