/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.plotly.api;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import org.apache.commons.math3.stat.StatUtils;
import tech.tablesaw.api.NumberColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.plotly.components.Axis;
import tech.tablesaw.plotly.components.Figure;
import tech.tablesaw.plotly.components.Layout;
import tech.tablesaw.plotly.traces.ScatterTrace;

public class TukeyMeanDifferencePlot {
    public static Figure create(String title, String measure, Table table, String columnName1, String columnName2) {
        NumberColumn xCol = table.nCol(columnName1);
        NumberColumn yCol = table.nCol(columnName2);
        return TukeyMeanDifferencePlot.create(title, measure, xCol.asDoubleArray(), yCol.asDoubleArray());
    }

    public static Figure create(String title, String measure, double[] xData, double[] yData) {
        Preconditions.checkArgument((xData.length != 0 ? 1 : 0) != 0, (Object)"x Data array is empty");
        Preconditions.checkArgument((yData.length != 0 ? 1 : 0) != 0, (Object)"x Data array is empty");
        if (xData.length != yData.length) {
            double[] interpolatedData;
            if (xData.length < yData.length) {
                interpolatedData = TukeyMeanDifferencePlot.interpolate(yData, xData.length);
                yData = interpolatedData;
            } else {
                interpolatedData = TukeyMeanDifferencePlot.interpolate(xData, yData.length);
                xData = interpolatedData;
            }
        }
        Arrays.sort(xData);
        Arrays.sort(yData);
        double[] averagePoints = new double[xData.length];
        double[] differencePoints = new double[xData.length];
        for (int i = 0; i < xData.length; ++i) {
            averagePoints[i] = (xData[i] + yData[i]) / 2.0;
            differencePoints[i] = xData[i] - yData[i];
        }
        double xMin = StatUtils.min((double[])xData);
        double xMax = StatUtils.max((double[])xData);
        double[] zeroLineX = new double[]{xMin, xMax};
        double[] zeroLineY = new double[]{0.0, 0.0};
        ScatterTrace trace1 = ScatterTrace.builder(zeroLineX, zeroLineY).mode(ScatterTrace.Mode.LINE).name("y = x").build();
        ScatterTrace trace2 = ScatterTrace.builder(averagePoints, differencePoints).name("mean x difference").build();
        Layout layout = Layout.builder().title(title).xAxis(Axis.builder().title("mean (" + measure + ")").build()).yAxis(Axis.builder().title("difference (" + measure + ")").build()).height(700).width(900).build();
        return new Figure(layout, trace1, trace2);
    }

    private static double[] interpolate(double[] source, int size) {
        double[] interpolatedData = new double[size];
        for (int i = 0; i < size; ++i) {
            double value = ((double)i + 0.5) / (double)size * 100.0;
            interpolatedData[i] = StatUtils.percentile((double[])source, (double)value);
        }
        return interpolatedData;
    }
}

