/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.plotly.traces;

import com.google.common.base.Preconditions;
import com.mitchellbosecke.pebble.error.PebbleException;
import com.mitchellbosecke.pebble.template.PebbleTemplate;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import tech.tablesaw.api.DateColumn;
import tech.tablesaw.api.DateTimeColumn;
import tech.tablesaw.api.TimeColumn;
import tech.tablesaw.columns.Column;
import tech.tablesaw.plotly.Utils;
import tech.tablesaw.plotly.components.HoverLabel;
import tech.tablesaw.plotly.components.Line;
import tech.tablesaw.plotly.components.Marker;
import tech.tablesaw.plotly.components.change.Decreasing;
import tech.tablesaw.plotly.components.change.Increasing;
import tech.tablesaw.plotly.traces.AbstractTrace;
import tech.tablesaw.plotly.traces.TraceBuilder;

public class ScatterTrace
extends AbstractTrace {
    static final Fill DEFAULT_FILL = Fill.NONE;
    static final double DEFAULT_WHISKER_WIDTH = 0.0;
    private final Fill fill;
    private final String fillColor;
    private final double[] y;
    private final Object[] x;
    private final String[] text;
    private final Mode mode;
    private final HoverLabel hoverLabel;
    private final boolean showLegend;
    private final Marker marker;
    private final Line line;
    private final double[] open;
    private final double[] high;
    private final double[] low;
    private final double[] close;
    private final double whiskerWidth;
    private final Increasing increasing;
    private final Decreasing decreasing;

    public static ScatterBuilder builder(double[] x, double[] y) {
        return new ScatterBuilder(x, y);
    }

    public static ScatterBuilder builder(DateColumn x, Column<? extends Number> y) {
        return new ScatterBuilder(x, y);
    }

    public static ScatterBuilder builder(Column x, Column<? extends Number> y) {
        return new ScatterBuilder(x, y);
    }

    public static ScatterBuilder builder(Column x, Column<? extends Number> open, Column<? extends Number> high, Column<? extends Number> low, Column<? extends Number> close) {
        return new ScatterBuilder(x, open, high, low, close);
    }

    public static ScatterBuilder builder(DateTimeColumn x, Column<? extends Number> y) {
        return new ScatterBuilder(x, y);
    }

    public static ScatterBuilder builder(TimeColumn x, Column<? extends Number> y) {
        return new ScatterBuilder(x, y);
    }

    private ScatterTrace(ScatterBuilder builder) {
        super(builder);
        this.mode = builder.mode;
        this.y = builder.y;
        this.x = builder.x;
        this.text = builder.text;
        this.marker = builder.marker;
        this.hoverLabel = builder.hoverLabel;
        this.showLegend = builder.showLegend;
        this.line = builder.line;
        this.fill = builder.fill;
        this.fillColor = builder.fillColor;
        this.open = builder.open;
        this.high = builder.high;
        this.low = builder.low;
        this.close = builder.close;
        this.whiskerWidth = builder.whiskerWidth;
        this.increasing = builder.increasing;
        this.decreasing = builder.decreasing;
    }

    private Map<String, Object> getContext(int i) {
        Map<String, Object> context = super.getContext();
        context.put("variableName", "trace" + i);
        context.put("mode", (Object)this.mode);
        context.put("x", Utils.dataAsString(this.x));
        if (this.y != null) {
            context.put("y", Utils.dataAsString(this.y));
        }
        if (this.open != null) {
            context.put("open", Utils.dataAsString(this.open));
        }
        if (this.high != null) {
            context.put("high", Utils.dataAsString(this.high));
        }
        if (this.low != null) {
            context.put("low", Utils.dataAsString(this.low));
        }
        if (this.close != null) {
            context.put("close", Utils.dataAsString(this.close));
        }
        if (this.whiskerWidth != 0.0) {
            context.put("whiskerWidth", this.whiskerWidth);
        }
        if (this.increasing != null) {
            context.put("increasing", this.increasing);
        }
        if (this.decreasing != null) {
            context.put("increasing", this.decreasing);
        }
        context.put("marker", this.marker);
        context.put("showlegend", this.showLegend);
        if (!this.fill.equals((Object)DEFAULT_FILL)) {
            context.put("fill", (Object)this.fill);
        }
        if (this.fillColor != null) {
            context.put("fillColor", this.fillColor);
        }
        if (this.hoverLabel != null) {
            context.put("hoverlabel", this.hoverLabel.asJavascript());
        }
        if (this.line != null) {
            context.put("line", this.line.asJavascript());
        }
        if (this.text != null) {
            context.put("text", Utils.dataAsString(this.text));
        }
        return context;
    }

    @Override
    public String asJavascript(int i) {
        StringWriter writer = new StringWriter();
        try {
            PebbleTemplate compiledTemplate = this.engine.getTemplate("trace_template.html");
            Map<String, Object> context = this.getContext(i);
            compiledTemplate.evaluate((Writer)writer, context);
        }
        catch (PebbleException | IOException e) {
            e.printStackTrace();
        }
        return ((Object)writer).toString();
    }

    public static class ScatterBuilder
    extends TraceBuilder {
        private String type = "scatter";
        private Mode mode = Mode.MARKERS;
        private final Object[] x;
        private double[] y;
        private String[] text;
        private Marker marker;
        private Line line;
        private double[] open;
        private double[] close;
        private double[] high;
        private double[] low;
        private Increasing increasing;
        private Decreasing decreasing;
        Fill fill = DEFAULT_FILL;
        String fillColor;
        double whiskerWidth = 0.0;

        private ScatterBuilder(double[] x, double[] y) {
            Double[] x1 = new Double[x.length];
            for (int i = 0; i < x1.length; ++i) {
                x1[i] = x[i];
            }
            this.x = x1;
            this.y = y;
        }

        private ScatterBuilder(Column x, Column<? extends Number> y) {
            this.x = x.asObjectArray();
            this.y = y.asDoubleArray();
        }

        private ScatterBuilder(Column x, Column<? extends Number> open, Column<? extends Number> high, Column<? extends Number> low, Column<? extends Number> close) {
            this.x = x.asObjectArray();
            this.open = open.asDoubleArray();
            this.high = high.asDoubleArray();
            this.low = low.asDoubleArray();
            this.close = close.asDoubleArray();
        }

        private ScatterBuilder(DateColumn x, Column<? extends Number> y) {
            this.x = x.asObjectArray();
            this.y = y.asDoubleArray();
        }

        private ScatterBuilder(DateTimeColumn x, Column<? extends Number> y) {
            this.x = x.asObjectArray();
            this.y = y.asDoubleArray();
        }

        private ScatterBuilder(TimeColumn x, Column<? extends Number> y) {
            this.x = x.asObjectArray();
            this.y = y.asDoubleArray();
        }

        public ScatterBuilder mode(Mode mode) {
            this.mode = mode;
            return this;
        }

        public ScatterBuilder line(Line line) {
            this.line = line;
            return this;
        }

        public ScatterBuilder whiskerWidth(double width) {
            Preconditions.checkArgument((width >= 0.0 && width <= 1.0 ? 1 : 0) != 0);
            this.whiskerWidth = width;
            return this;
        }

        public ScatterBuilder marker(Marker marker) {
            this.marker = marker;
            return this;
        }

        public ScatterBuilder type(String kind) {
            this.type = kind;
            return this;
        }

        public ScatterBuilder text(String[] text) {
            this.text = text;
            return this;
        }

        public ScatterBuilder increasing(Increasing increasing) {
            this.increasing = increasing;
            return this;
        }

        public ScatterBuilder decreasing(Decreasing decreasing) {
            this.decreasing = decreasing;
            return this;
        }

        public ScatterBuilder fill(Fill fill) {
            this.fill = fill;
            return this;
        }

        public ScatterBuilder fillColor(String fillColor) {
            this.fillColor = fillColor;
            return this;
        }

        public ScatterTrace build() {
            return new ScatterTrace(this);
        }

        @Override
        protected String getType() {
            return this.type;
        }

        @Override
        public ScatterBuilder name(String name) {
            return (ScatterBuilder)super.name(name);
        }

        @Override
        public ScatterBuilder opacity(double n) {
            Preconditions.checkArgument((n >= 0.0 && n <= 1.0 ? 1 : 0) != 0);
            return (ScatterBuilder)super.opacity(n);
        }

        @Override
        public ScatterBuilder legendGroup(String group) {
            return (ScatterBuilder)super.legendGroup(group);
        }

        @Override
        public ScatterBuilder showLegend(boolean showLegend) {
            return (ScatterBuilder)super.showLegend(showLegend);
        }

        @Override
        public ScatterBuilder visible(AbstractTrace.Visibility visibility) {
            return (ScatterBuilder)super.visible(visibility);
        }

        @Override
        public ScatterBuilder hoverLabel(HoverLabel hoverLabel) {
            return (ScatterBuilder)super.hoverLabel(hoverLabel);
        }
    }

    public static enum Mode {
        LINE("lines"),
        MARKERS("markers"),
        LINE_AND_MARKERS("lines+markers"),
        LINE_AND_TEXT("lines+text"),
        TEXT_AND_MARKERS("markers+text"),
        LINE_TEXT_AND_MARKERS("lines+markers+text"),
        TEXT("text"),
        NONE("none");

        final String value;

        private Mode(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum Fill {
        NONE("none"),
        TO_ZERO_Y("tozeroy"),
        TO_ZERO_X("tozerox"),
        TO_NEXT_Y("tonexty"),
        TO_NEXT_X("tonextx"),
        TO_SELF("toself"),
        TO_NEXT("tonext");

        private final String value;

        private Fill(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

