/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.plotly.components;

import com.mitchellbosecke.pebble.PebbleEngine;
import com.mitchellbosecke.pebble.error.PebbleException;
import com.mitchellbosecke.pebble.template.PebbleTemplate;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import tech.tablesaw.plotly.components.Axis;
import tech.tablesaw.plotly.components.Font;
import tech.tablesaw.plotly.components.Margin;
import tech.tablesaw.plotly.components.TemplateUtils;
import tech.tablesaw.plotly.components.threeD.Scene;

public class Layout {
    private static final String DEFAULT_TITLE = "";
    private static final String DEFAULT_PAPER_BG_COLOR = "#fff";
    private static final String DEFAULT_PLOT_BG_COLOR = "#fff";
    private static final String DEFAULT_DECIMAL_SEPARATOR = ".";
    private static final String DEFAULT_THOUSANDS_SEPARATOR = ",";
    private static final boolean DEFAULT_AUTO_SIZE = false;
    private static final boolean DEFAULT_SHOW_LEGEND = false;
    private static final HoverMode DEFAULT_HOVER_MODE = HoverMode.FALSE;
    private static final DragMode DEFAULT_DRAG_MODE = DragMode.ZOOM;
    private static final int DEFAULT_HOVER_DISTANCE = 20;
    private static final BarMode DEFAULT_BAR_MODE = BarMode.GROUP;
    private static final Font DEFAULT_TITLE_FONT = Font.builder().build();
    private static final Font DEFAULT_FONT = Font.builder().build();
    private final PebbleEngine engine = TemplateUtils.getNewEngine();
    private final Scene scene;
    private final Font font;
    private final String title;
    private final Font titleFont;
    private final boolean autoSize;
    private final int width;
    private final int height;
    private final Margin margin;
    private final String paperBgColor;
    private final String plotBgColor;
    private final String decimalSeparator;
    private final String thousandsSeparator;
    private final boolean showLegend;
    private final HoverMode hoverMode;
    private final DragMode dragMode;
    private final int hoverDistance;
    private final Axis xAxis;
    private final Axis yAxis;
    private final Axis zAxis;
    private final BarMode barMode;

    private Layout(LayoutBuilder builder) {
        this.title = builder.title;
        this.autoSize = builder.autoSize;
        this.decimalSeparator = builder.decimalSeparator;
        this.thousandsSeparator = builder.thousandsSeparator;
        this.dragMode = builder.dragMode;
        this.font = builder.font;
        this.titleFont = builder.titleFont;
        this.hoverDistance = builder.hoverDistance;
        this.hoverMode = builder.hoverMode;
        this.margin = builder.margin;
        this.height = builder.height;
        this.width = builder.width;
        this.xAxis = builder.xAxis;
        this.yAxis = builder.yAxis;
        this.zAxis = builder.zAxis;
        this.paperBgColor = builder.paperBgColor;
        this.plotBgColor = builder.plotBgColor;
        this.showLegend = builder.showLegend;
        this.barMode = builder.barMode;
        this.scene = builder.scene;
    }

    public String getTitle() {
        return this.title;
    }

    public String asJavascript() {
        StringWriter writer = new StringWriter();
        try {
            PebbleTemplate compiledTemplate = this.engine.getTemplate("layout_template.html");
            compiledTemplate.evaluate((Writer)writer, this.getContext());
        }
        catch (PebbleException | IOException e) {
            e.printStackTrace();
        }
        return ((Object)writer).toString();
    }

    protected Map<String, Object> getContext() {
        HashMap<String, Object> context = new HashMap<String, Object>();
        if (!this.title.equals(DEFAULT_TITLE)) {
            context.put("title", this.title);
        }
        if (!this.titleFont.equals(DEFAULT_TITLE_FONT)) {
            context.put("titlefont", this.titleFont);
        }
        context.put("width", this.width);
        context.put("height", this.height);
        if (!this.font.equals(DEFAULT_FONT)) {
            context.put("font", this.font);
        }
        if (!(!this.autoSize)) {
            context.put("autosize", this.autoSize);
        }
        if (this.hoverDistance != 20) {
            context.put("hoverdistance", this.hoverDistance);
        }
        if (!this.hoverMode.equals((Object)DEFAULT_HOVER_MODE)) {
            context.put("hoverMode", (Object)this.hoverMode);
        }
        if (this.margin != null) {
            context.put("margin", this.margin);
        }
        if (!this.decimalSeparator.equals(DEFAULT_DECIMAL_SEPARATOR)) {
            context.put("decimalSeparator", this.decimalSeparator);
        }
        if (!this.thousandsSeparator.equals(DEFAULT_THOUSANDS_SEPARATOR)) {
            context.put("thousandsSeparator", this.thousandsSeparator);
        }
        if (!this.dragMode.equals((Object)DEFAULT_DRAG_MODE)) {
            context.put("dragmode", (Object)this.dragMode);
        }
        if (!(!this.showLegend)) {
            context.put("showlegend", this.showLegend);
        }
        if (!this.plotBgColor.equals("#fff")) {
            context.put("plotbgcolor", this.plotBgColor);
        }
        if (!this.paperBgColor.equals("#fff")) {
            context.put("paperbgcolor", this.paperBgColor);
        }
        if (!this.barMode.equals((Object)DEFAULT_BAR_MODE)) {
            context.put("barMode", (Object)this.barMode);
        }
        if (this.scene != null) {
            context.put("scene", this.scene);
        }
        if (this.xAxis != null) {
            context.put("xAxis", this.xAxis);
        }
        if (this.yAxis != null) {
            context.put("yAxis", this.yAxis);
        }
        if (this.zAxis != null) {
            context.put("zAxis", this.zAxis);
        }
        return context;
    }

    public static LayoutBuilder builder() {
        return new LayoutBuilder();
    }

    static /* synthetic */ Font access$200() {
        return DEFAULT_FONT;
    }

    static /* synthetic */ Font access$300() {
        return DEFAULT_TITLE_FONT;
    }

    static /* synthetic */ HoverMode access$400() {
        return DEFAULT_HOVER_MODE;
    }

    static /* synthetic */ DragMode access$500() {
        return DEFAULT_DRAG_MODE;
    }

    static /* synthetic */ BarMode access$600() {
        return DEFAULT_BAR_MODE;
    }

    public static class LayoutBuilder {
        final Font font = Layout.access$200();
        String title = "";
        Font titleFont = Layout.access$300();
        final boolean autoSize = false;
        int width = 700;
        int height = 450;
        Margin margin;
        String paperBgColor = "#fff";
        String plotBgColor = "#fff";
        final String decimalSeparator = ".";
        final String thousandsSeparator = ",";
        boolean showLegend = false;
        HoverMode hoverMode = Layout.access$400();
        final DragMode dragMode = Layout.access$500();
        int hoverDistance = 20;
        Axis xAxis;
        Axis yAxis;
        Axis zAxis;
        BarMode barMode = Layout.access$600();
        private Scene scene;

        public Layout build() {
            return new Layout(this);
        }

        private LayoutBuilder() {
        }

        public LayoutBuilder title(String title) {
            this.title = title;
            return this;
        }

        public LayoutBuilder titleFont(Font titleFont) {
            this.titleFont = titleFont;
            return this;
        }

        public LayoutBuilder barMode(BarMode barMode) {
            this.barMode = barMode;
            return this;
        }

        public LayoutBuilder margin(Margin margin) {
            this.margin = margin;
            return this;
        }

        public LayoutBuilder scene(Scene scene) {
            this.scene = scene;
            return this;
        }

        public LayoutBuilder hoverMode(HoverMode hoverMode) {
            this.hoverMode = hoverMode;
            return this;
        }

        public LayoutBuilder hoverDistance(int distance) {
            this.hoverDistance = distance;
            return this;
        }

        public LayoutBuilder showLegend(boolean showLegend) {
            this.showLegend = showLegend;
            return this;
        }

        public LayoutBuilder height(int height) {
            this.height = height;
            return this;
        }

        public LayoutBuilder width(int width) {
            this.width = width;
            return this;
        }

        public LayoutBuilder xAxis(Axis axis) {
            this.xAxis = axis;
            return this;
        }

        public LayoutBuilder yAxis(Axis axis) {
            this.yAxis = axis;
            return this;
        }

        public LayoutBuilder zAxis(Axis axis) {
            this.zAxis = axis;
            return this;
        }

        public LayoutBuilder plotBgColor(String color) {
            this.plotBgColor = color;
            return this;
        }

        public LayoutBuilder paperBgColor(String color) {
            this.paperBgColor = color;
            return this;
        }
    }

    public static enum DragMode {
        ZOOM("zoom"),
        PAN("pan"),
        SELECT("select"),
        LASSO("lasso"),
        ORBIT("orbit"),
        TURNTABLE("turntable");

        private final String value;

        private DragMode(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum BarMode {
        STACK("stack"),
        GROUP("group"),
        OVERLAY("overlay"),
        RELATIVE("relative");

        private final String value;

        private BarMode(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum HoverMode {
        X("x"),
        Y("y"),
        CLOSEST("closest"),
        FALSE("false");

        private final String value;

        private HoverMode(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

