/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.plotly.traces;

import com.mitchellbosecke.pebble.PebbleEngine;
import com.mitchellbosecke.pebble.error.PebbleException;
import com.mitchellbosecke.pebble.template.PebbleTemplate;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import tech.tablesaw.plotly.components.HoverLabel;
import tech.tablesaw.plotly.components.TemplateUtils;
import tech.tablesaw.plotly.traces.Trace;
import tech.tablesaw.plotly.traces.TraceBuilder;

public abstract class AbstractTrace
implements Trace {
    static final double DEFAULT_OPACITY = 1.0;
    static final Visibility DEFAULT_VISIBILITY = Visibility.TRUE;
    static final boolean DEFAULT_SHOW_LEGEND = false;
    protected final PebbleEngine engine = TemplateUtils.getNewEngine();
    protected final String type;
    private final Visibility visible;
    private final boolean showLegend;
    private final String legendGroup;
    private final double opacity;
    private final String name;
    private final String[] ids;
    private final HoverLabel hoverLabel;

    public AbstractTrace(TraceBuilder builder) {
        this.type = builder.getType();
        this.name = builder.name;
        this.showLegend = builder.showLegend;
        this.legendGroup = builder.legendGroup;
        this.visible = builder.visible;
        this.ids = builder.ids;
        this.hoverLabel = builder.hoverLabel;
        this.opacity = builder.opacity;
    }

    @Override
    public String name() {
        return this.name;
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        try {
            PebbleTemplate compiledTemplate = this.engine.getTemplate("trace_template.html");
            compiledTemplate.evaluate((Writer)writer, this.getContext());
        }
        catch (PebbleException | IOException e) {
            e.printStackTrace();
        }
        return ((Object)writer).toString();
    }

    protected Map<String, Object> getContext() {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("type", this.type);
        context.put("name", this.name);
        if (this.showLegend) {
            context.put("showLegend", this.showLegend);
        }
        context.put("legendGroup", this.legendGroup);
        if (!this.visible.equals((Object)DEFAULT_VISIBILITY)) {
            context.put("visible", (Object)this.visible);
        }
        context.put("ids", this.ids);
        context.put("hoverLable", this.hoverLabel);
        if (this.opacity != 1.0) {
            context.put("opacity", this.opacity);
        }
        return context;
    }

    @Override
    public HoverLabel hoverLabel() {
        return this.hoverLabel;
    }

    @Override
    public boolean showLegend() {
        return this.showLegend;
    }

    public static enum Visibility {
        TRUE("True"),
        FALSE("False"),
        LEGEND_ONLY("legendonly");

        private String value;

        private Visibility(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

