/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.plotly.components;

import com.google.common.base.Preconditions;
import com.mitchellbosecke.pebble.error.PebbleException;
import com.mitchellbosecke.pebble.template.PebbleTemplate;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import tech.tablesaw.plotly.components.Component;

public class Grid
extends Component {
    private int rows;
    private RowOrder rowOrder;
    private int columns;
    private double xGap;
    private double yGap;

    public Grid(GridBuilder gridBuilder) {
        this.rows = gridBuilder.rows;
        this.columns = gridBuilder.columns;
        this.rowOrder = gridBuilder.rowOrder;
        this.xGap = gridBuilder.xGap;
        this.yGap = gridBuilder.yGap;
    }

    @Override
    public String asJavascript() {
        StringWriter writer = new StringWriter();
        try {
            PebbleTemplate compiledTemplate = this.engine.getTemplate("grid_template.html");
            compiledTemplate.evaluate((Writer)writer, this.getContext());
        }
        catch (PebbleException | IOException e) {
            e.printStackTrace();
        }
        return ((Object)writer).toString();
    }

    private Map<String, Object> getContext() {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("xGap", this.xGap);
        context.put("yGap", this.yGap);
        context.put("rows", this.rows);
        context.put("columns", this.columns);
        context.put("rowOrder", (Object)this.rowOrder);
        return context;
    }

    public GridBuilder gridBuilder() {
        return new GridBuilder();
    }

    public static class GridBuilder {
        int rows = 80;
        int columns = 80;
        double xGap = 100.0;
        double yGap = 80.0;
        RowOrder rowOrder = RowOrder.TOP_TO_BOTTOM;

        private GridBuilder() {
        }

        public GridBuilder rows(int rows) {
            Preconditions.checkArgument((rows >= 1 ? 1 : 0) != 0);
            this.rows = rows;
            return this;
        }

        public GridBuilder columns(int columns) {
            Preconditions.checkArgument((this.rows >= 1 ? 1 : 0) != 0);
            this.columns = columns;
            return this;
        }

        public GridBuilder xGap(double xGap) {
            Preconditions.checkArgument((xGap >= 0.0 && xGap <= 1.0 ? 1 : 0) != 0);
            this.xGap = xGap;
            return this;
        }

        public GridBuilder yGap(double yGap) {
            Preconditions.checkArgument((yGap >= 0.0 && yGap <= 1.0 ? 1 : 0) != 0);
            this.yGap = yGap;
            return this;
        }

        public GridBuilder rowOrder(RowOrder rowOrder) {
            this.rowOrder = rowOrder;
            return this;
        }

        public Grid build() {
            return new Grid(this);
        }
    }

    public static enum RowOrder {
        ENUMERATED,
        TOP_TO_BOTTOM,
        BOTTOM_TO_TOP;

    }
}

