/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.plotly.components;

import com.mitchellbosecke.pebble.PebbleEngine;
import com.mitchellbosecke.pebble.error.PebbleException;
import com.mitchellbosecke.pebble.template.PebbleTemplate;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import tech.tablesaw.plotly.components.Layout;
import tech.tablesaw.plotly.components.TemplateUtils;
import tech.tablesaw.plotly.traces.Trace;

public class Figure {
    private Trace[] data;
    private Layout layout;
    private Map<String, Object> context = new HashMap<String, Object>();
    private final PebbleEngine engine = TemplateUtils.getNewEngine();

    public Figure(Layout layout, Trace ... traces) {
        this.data = traces;
        this.layout = layout;
    }

    public Figure(Trace ... traces) {
        this.data = traces;
        this.layout = null;
    }

    public String asJavascript(String divName) {
        StringWriter writer = new StringWriter();
        this.buildContext(divName);
        try {
            PebbleTemplate compiledTemplate = this.engine.getTemplate("figure_template.html");
            compiledTemplate.evaluate((Writer)writer, this.getContext());
        }
        catch (PebbleException | IOException e) {
            e.printStackTrace();
        }
        return ((Object)writer).toString();
    }

    private void buildContext(String divName) {
        String targetName = "target_" + divName;
        this.context.put("divName", divName);
        this.context.put("targetName", targetName);
        StringBuilder builder = new StringBuilder();
        if (this.layout != null) {
            builder.append(this.layout.asJavascript());
        }
        builder.append('\n');
        for (int i = 0; i < this.data.length; ++i) {
            Trace trace = this.data[i];
            builder.append(trace.asJavascript(i));
            builder.append('\n');
        }
        builder.append('\n');
        String figure = builder.toString();
        this.context.put("figure", figure);
        this.context.put("plotFunction", this.plotFunction(targetName));
    }

    private String plotFunction(String divName) {
        StringBuilder builder = new StringBuilder();
        builder.append("var data = [ ");
        for (int i = 0; i < this.data.length; ++i) {
            builder.append("trace").append(i);
            if (i >= this.data.length - 1) continue;
            builder.append(", ");
        }
        builder.append("];\n");
        builder.append("Plotly.newPlot(").append(divName).append(", ").append("data");
        if (this.layout != null) {
            builder.append(", ");
            builder.append("layout");
        }
        builder.append(");");
        return builder.toString();
    }

    public Map<String, Object> getContext() {
        return this.context;
    }
}

