/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.io.html;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.Column;
import tech.tablesaw.io.DataWriter;
import tech.tablesaw.io.Destination;
import tech.tablesaw.io.ParsingUtils;
import tech.tablesaw.io.WriterRegistry;
import tech.tablesaw.io.html.HtmlWriteOptions;

public class HtmlWriter
implements DataWriter<HtmlWriteOptions> {
    private static final HtmlWriter INSTANCE = new HtmlWriter();

    public static void register(WriterRegistry registry) {
        registry.registerExtension("html", (DataWriter)INSTANCE);
        registry.registerOptions(HtmlWriteOptions.class, (DataWriter)INSTANCE);
    }

    public void write(Table table, HtmlWriteOptions options) {
        StringBuilder builder = new StringBuilder();
        builder.append("<table>").append(System.lineSeparator());
        builder.append(HtmlWriter.header(table.columnNames()));
        builder.append("<tbody>").append(System.lineSeparator());
        for (int row = 0; row < table.rowCount(); ++row) {
            builder.append(HtmlWriter.row(row, table));
        }
        builder.append("</tbody>").append(System.lineSeparator());
        builder.append("</table>");
        String str = builder.toString();
        try {
            Writer writer = options.destination().createWriter();
            writer.write(str);
            writer.flush();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static String row(int row, Table table) {
        StringBuilder builder = new StringBuilder().append("<tr>");
        for (Column col : table.columns()) {
            builder.append("<td>").append(String.valueOf(col.getString(row))).append("</td>");
        }
        builder.append("</tr>").append(System.lineSeparator());
        return builder.toString();
    }

    private static String header(List<String> columnNames) {
        StringBuilder builder = new StringBuilder().append("<thead>").append(System.lineSeparator()).append("<tr>");
        for (String name : columnNames) {
            builder.append("<th>").append(ParsingUtils.splitCamelCase((String)ParsingUtils.splitOnUnderscore((String)name))).append("</th>");
        }
        builder.append("</tr>").append(System.lineSeparator()).append("</thead>").append(System.lineSeparator());
        return builder.toString();
    }

    public void write(Table table, Destination dest) {
        this.write(table, HtmlWriteOptions.build(dest).build());
    }

    static {
        HtmlWriter.register(Table.defaultWriterRegistry);
    }
}

