/*
 * Decompiled with CFR 0.152.
 */
package tech.skot.core.components;

import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.lifecycle.DefaultLifecycleObserver;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.recyclerview.widget.RecyclerView;
import androidx.viewpager2.adapter.FragmentStateAdapter;
import androidx.viewpager2.widget.ViewPager2;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.skot.core.components.SKActivity;
import tech.skot.core.components.SKComponentView;
import tech.skot.core.components.SKPagerViewProxy;
import tech.skot.core.components.SKScreenViewProxy;
import tech.skot.view.live.SKLifecycle;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\t\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\nJ+\u0010\u000f\u001a\u00020\u00102#\u0010\u0011\u001a\u001f\u0012\u0013\u0012\u00110\u0013\u00a2\u0006\f\b\u0014\u0012\b\b\u0015\u0012\u0004\b\b(\u0016\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u0012J\b\u0010\u0017\u001a\u00020\u0010H\u0016J\u0018\u0010\u0018\u001a\u00020\u00102\u0010\u0010\u0019\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001b0\u001aJ\u000e\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u0013J\u000e\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020 J\b\u0010!\u001a\u00020\u0010H\u0002R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\t\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Ltech/skot/core/components/SKPagerView;", "Ltech/skot/core/components/SKComponentView;", "Landroidx/viewpager2/widget/ViewPager2;", "proxy", "Ltech/skot/core/components/SKPagerViewProxy;", "activity", "Ltech/skot/core/components/SKActivity;", "fragment", "Landroidx/fragment/app/Fragment;", "viewPager2", "(Ltech/skot/core/components/SKPagerViewProxy;Ltech/skot/core/components/SKActivity;Landroidx/fragment/app/Fragment;Landroidx/viewpager2/widget/ViewPager2;)V", "onUserSwipeCallBack", "Landroidx/viewpager2/widget/ViewPager2$OnPageChangeCallback;", "getProxy", "()Ltech/skot/core/components/SKPagerViewProxy;", "onOnUserSwipeToPage", "", "onSwipeToPage", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "index", "onRecycle", "onScreens", "screens", "", "Ltech/skot/core/components/SKScreenViewProxy;", "onSelectedPageIndex", "selectedPageIndex", "onSwipable", "value", "", "unregisterCallBack", "viewlegacy_release"})
@SourceDebugExtension(value={"SMAP\nSKPagerView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SKPagerView.kt\ntech/skot/core/components/SKPagerView\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,82:1\n1#2:83\n*E\n"})
public final class SKPagerView
extends SKComponentView<ViewPager2> {
    @NotNull
    private final SKPagerViewProxy proxy;
    @NotNull
    private final ViewPager2 viewPager2;
    @Nullable
    private ViewPager2.OnPageChangeCallback onUserSwipeCallBack;

    public SKPagerView(@NotNull SKPagerViewProxy proxy, @NotNull SKActivity activity, @Nullable Fragment fragment, @NotNull ViewPager2 viewPager2) {
        Intrinsics.checkNotNullParameter((Object)proxy, (String)"proxy");
        Intrinsics.checkNotNullParameter((Object)((Object)activity), (String)"activity");
        Intrinsics.checkNotNullParameter((Object)viewPager2, (String)"viewPager2");
        super(proxy, activity, fragment, viewPager2);
        this.proxy = proxy;
        this.viewPager2 = viewPager2;
        this.getLifecycleOwner().getSkLifecycle().addObserver((LifecycleObserver)new DefaultLifecycleObserver(){

            public void onDestroy(@NotNull LifecycleOwner owner) {
                Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
                super.onDestroy(owner);
                this.unregisterCallBack();
            }
        });
    }

    @NotNull
    public SKPagerViewProxy getProxy() {
        return this.proxy;
    }

    public final void onScreens(@NotNull List<? extends SKScreenViewProxy<?>> screens) {
        Intrinsics.checkNotNullParameter(screens, (String)"screens");
        FragmentManager fragmentManager = this.getFragmentManager();
        SKLifecycle sKLifecycle = this.getLifecycleOwner().getLifecycle();
        this.viewPager2.setAdapter((RecyclerView.Adapter)new FragmentStateAdapter(screens, fragmentManager, sKLifecycle){
            final /* synthetic */ List<SKScreenViewProxy<?>> $screens;
            {
                this.$screens = $screens;
                super($super_call_param$1, (Lifecycle)$super_call_param$2);
            }

            public int getItemCount() {
                return this.$screens.size();
            }

            @NotNull
            public Fragment createFragment(int position) {
                return this.$screens.get(position).createFragment(false);
            }
        });
    }

    public final void onSelectedPageIndex(int selectedPageIndex) {
        this.viewPager2.post(() -> SKPagerView.onSelectedPageIndex$lambda$0(this, selectedPageIndex));
    }

    /*
     * WARNING - void declaration
     */
    public final void onOnUserSwipeToPage(@Nullable Function1<? super Integer, Unit> onSwipeToPage) {
        void it;
        ViewPager2.OnPageChangeCallback onPageChangeCallback;
        Ref.BooleanRef userSwipe = new Ref.BooleanRef();
        ViewPager2.OnPageChangeCallback onPageChangeCallback2 = onPageChangeCallback = new ViewPager2.OnPageChangeCallback(userSwipe, this, onSwipeToPage){
            final /* synthetic */ Ref.BooleanRef $userSwipe;
            final /* synthetic */ SKPagerView this$0;
            final /* synthetic */ Function1<Integer, Unit> $onSwipeToPage;
            {
                this.$userSwipe = $userSwipe;
                this.this$0 = $receiver;
                this.$onSwipeToPage = $onSwipeToPage;
            }

            public void onPageScrollStateChanged(int state) {
                switch (state) {
                    case 1: {
                        this.$userSwipe.element = true;
                        break;
                    }
                    case 0: {
                        this.$userSwipe.element = false;
                    }
                }
            }

            public void onPageSelected(int position) {
                block1: {
                    if (!this.$userSwipe.element) break block1;
                    this.this$0.getProxy().setSelectedPageIndex(position);
                    Function1<Integer, Unit> function1 = this.$onSwipeToPage;
                    if (function1 != null) {
                        function1.invoke((Object)position);
                    }
                }
            }
        };
        ViewPager2 viewPager2 = this.viewPager2;
        boolean bl = false;
        this.onUserSwipeCallBack = (ViewPager2.OnPageChangeCallback)it;
        viewPager2.registerOnPageChangeCallback(onPageChangeCallback);
    }

    private final void unregisterCallBack() {
        block0: {
            ViewPager2.OnPageChangeCallback onPageChangeCallback = this.onUserSwipeCallBack;
            if (onPageChangeCallback == null) break block0;
            ViewPager2.OnPageChangeCallback it = onPageChangeCallback;
            boolean bl = false;
            this.viewPager2.unregisterOnPageChangeCallback(it);
            this.onUserSwipeCallBack = null;
        }
    }

    @Override
    public void onRecycle() {
        super.onRecycle();
        this.unregisterCallBack();
    }

    public final void onSwipable(boolean value) {
        this.viewPager2.setUserInputEnabled(value);
    }

    private static final void onSelectedPageIndex$lambda$0(SKPagerView this$0, int $selectedPageIndex) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.viewPager2.setCurrentItem($selectedPageIndex);
    }
}

