/*
 * Decompiled with CFR 0.152.
 */
package tech.relaycorp.relaynet.testing.keystores;

import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.relaycorp.relaynet.keystores.CertificateStore;
import tech.relaycorp.relaynet.keystores.KeyStoreBackendException;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\r\u0018\u00002\u00020\u0001B)\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0010\u001a\u00020\u0011J\u0018\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\nH\u0016J\u0011\u0010\u0015\u001a\u00020\u0011H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0016J'\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\r0\u000b2\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\nH\u0094@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0018J1\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\nH\u0094@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001cJ&\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\nR;\u0010\u0007\u001a,\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\t\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\t0\u000b0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001e"}, d2={"Ltech/relaycorp/relaynet/testing/keystores/MockCertificateStore;", "Ltech/relaycorp/relaynet/keystores/CertificateStore;", "savingException", "", "retrievalException", "deleteException", "(Ljava/lang/Throwable;Ljava/lang/Throwable;Ljava/lang/Throwable;)V", "certificationPaths", "", "Lkotlin/Pair;", "", "", "Ljava/time/ZonedDateTime;", "", "getCertificationPaths", "()Ljava/util/Map;", "clear", "", "delete", "subjectId", "issuerId", "deleteExpired", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "retrieveData", "(Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "saveData", "leafCertificateExpiryDate", "certificationPathData", "(Ljava/lang/String;Ljava/time/ZonedDateTime;[BLjava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "setCertificate", "awala-testing"})
public final class MockCertificateStore
extends CertificateStore {
    @Nullable
    private final Throwable savingException;
    @Nullable
    private final Throwable retrievalException;
    @Nullable
    private final Throwable deleteException;
    @NotNull
    private final Map<Pair<String, String>, List<Pair<ZonedDateTime, byte[]>>> certificationPaths;

    public MockCertificateStore(@Nullable Throwable savingException, @Nullable Throwable retrievalException, @Nullable Throwable deleteException) {
        this.savingException = savingException;
        this.retrievalException = retrievalException;
        this.deleteException = deleteException;
        this.certificationPaths = new LinkedHashMap();
    }

    public /* synthetic */ MockCertificateStore(Throwable throwable, Throwable throwable2, Throwable throwable3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            throwable = null;
        }
        if ((n & 2) != 0) {
            throwable2 = null;
        }
        if ((n & 4) != 0) {
            throwable3 = null;
        }
        this(throwable, throwable2, throwable3);
    }

    @NotNull
    public final Map<Pair<String, String>, List<Pair<ZonedDateTime, byte[]>>> getCertificationPaths() {
        return this.certificationPaths;
    }

    public final void clear() {
        this.certificationPaths.clear();
    }

    @Nullable
    protected Object saveData(@NotNull String subjectId, @NotNull ZonedDateTime leafCertificateExpiryDate, @NotNull byte[] certificationPathData, @NotNull String issuerId, @NotNull Continuation<? super Unit> $completion) {
        if (this.savingException != null) {
            throw new KeyStoreBackendException("Saving certificates isn't supported", this.savingException);
        }
        this.setCertificate(subjectId, leafCertificateExpiryDate, certificationPathData, issuerId);
        return Unit.INSTANCE;
    }

    public final void setCertificate(@NotNull String subjectId, @NotNull ZonedDateTime leafCertificateExpiryDate, @NotNull byte[] certificationPathData, @NotNull String issuerId) {
        Intrinsics.checkNotNullParameter((Object)subjectId, (String)"subjectId");
        Intrinsics.checkNotNullParameter((Object)leafCertificateExpiryDate, (String)"leafCertificateExpiryDate");
        Intrinsics.checkNotNullParameter((Object)certificationPathData, (String)"certificationPathData");
        Intrinsics.checkNotNullParameter((Object)issuerId, (String)"issuerId");
        Pair pair = TuplesKt.to((Object)subjectId, (Object)issuerId);
        List list = this.certificationPaths.get(TuplesKt.to((Object)subjectId, (Object)issuerId));
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        this.certificationPaths.put((Pair<String, String>)pair, CollectionsKt.plus((Collection)list, (Object)new Pair((Object)leafCertificateExpiryDate, (Object)certificationPathData)));
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    protected Object retrieveData(@NotNull String subjectId, @NotNull String issuerId, @NotNull Continuation<? super List<byte[]>> $completion) {
        List list;
        List list2;
        if (this.retrievalException != null) {
            throw new KeyStoreBackendException("Retrieving certificates isn't supported", this.retrievalException);
        }
        List<Pair<ZonedDateTime, byte[]>> list3 = this.certificationPaths.get(TuplesKt.to((Object)subjectId, (Object)issuerId));
        if (list3 != null) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = list3;
            boolean $i$f$map = false;
            void var7_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Pair pair = (Pair)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add((byte[])it.getSecond());
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = list = null;
        }
        if (list2 == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    public void delete(@NotNull String subjectId, @NotNull String issuerId) {
        Intrinsics.checkNotNullParameter((Object)subjectId, (String)"subjectId");
        Intrinsics.checkNotNullParameter((Object)issuerId, (String)"issuerId");
        if (this.deleteException != null) {
            throw new KeyStoreBackendException("Deleting certificates isn't supported", this.deleteException);
        }
        this.certificationPaths.remove(TuplesKt.to((Object)subjectId, (Object)issuerId));
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public Object deleteExpired(@NotNull Continuation<? super Unit> $completion) {
        if (this.deleteException != null) {
            throw new KeyStoreBackendException("Deleting certificates isn't supported", this.deleteException);
        }
        Map<Pair<String, String>, List<Pair<ZonedDateTime, byte[]>>> $this$forEach$iv = this.certificationPaths;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<Pair<String, String>, List<Pair<ZonedDateTime, byte[]>>>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void $this$filterTo$iv$iv;
            Map.Entry<Pair<String, String>, List<Pair<ZonedDateTime, byte[]>>> element$iv;
            Map.Entry<Pair<String, String>, List<Pair<ZonedDateTime, byte[]>>> entry = element$iv = iterator.next();
            boolean bl = false;
            Pair<String, String> address = entry.getKey();
            List<Pair<ZonedDateTime, byte[]>> list = entry.getValue();
            Map<Pair<String, String>, List<Pair<ZonedDateTime, byte[]>>> map = this.certificationPaths;
            Iterable $this$filter$iv = list;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Pair it = (Pair)element$iv$iv;
                boolean bl2 = false;
                if (!(((ZonedDateTime)it.getFirst()).compareTo(ZonedDateTime.now()) >= 0)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List list2 = (List)destination$iv$iv;
            map.put(address, list2);
        }
        return Unit.INSTANCE;
    }

    public MockCertificateStore() {
        this(null, null, null, 7, null);
    }
}

