/*
 * Decompiled with CFR 0.152.
 */
package tech.pylons.lib.types;

import java.util.Arrays;
import kotlin.ExperimentalUnsignedTypes;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongycastle.util.encoders.Hex;
import tech.pylons.lib.types.AminoCompat;
import tech.pylons.lib.types.Bech32Cosmos;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0007\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0002\u001a\u00020\u0003J\u0006\u0010\u0007\u001a\u00020\bJ\u0013\u0010\t\u001a\u00020\b2\b\u0010\n\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Ltech/pylons/lib/types/AccAddress;", "", "bytes", "", "([B)V", "getBytes", "()[B", "empty", "", "equals", "other", "hashCode", "", "toString", "", "Companion", "libpylons"})
@ExperimentalUnsignedTypes
public final class AccAddress {
    @NotNull
    private final byte[] bytes;
    public static final int addrLen = 20;
    @NotNull
    public static final String bech32MainPrefix = "cosmos";
    @NotNull
    public static final String prefixAccount = "acc";
    @NotNull
    public static final String prefixPublic = "pub";
    @NotNull
    public static final String prefixAddress = "addr";
    @NotNull
    public static final String bech32PrefixAccAddr = "cosmos";
    @NotNull
    public static final String bech32PrefixAccPub = "cosmospub";
    @NotNull
    public static final Companion Companion = new Companion(null);

    public boolean equals(@Nullable Object other) {
        boolean bl;
        boolean bl2;
        AccAddress accAddress = (AccAddress)other;
        if (accAddress == null) {
            return false;
        }
        AccAddress aa2 = accAddress;
        boolean bl3 = bl2 = this.empty() && aa2.empty();
        if (bl2) {
            bl = true;
        } else if (!bl2) {
            byte[] byArray = this.bytes;
            byte[] byArray2 = aa2.bytes;
            boolean bl4 = false;
            bl = Arrays.equals(byArray, byArray2);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    public final boolean empty() {
        byte[] byArray = this.bytes;
        boolean bl = false;
        return byArray.length == 0;
    }

    @NotNull
    public final byte[] bytes() {
        return this.bytes;
    }

    @NotNull
    public String toString() {
        String string;
        boolean bl = this.empty();
        if (bl) {
            string = "";
        } else if (!bl) {
            string = Bech32Cosmos.Companion.convertAndEncode("cosmos", this.bytes);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    public int hashCode() {
        byte[] byArray = this.bytes;
        boolean bl = false;
        return Arrays.hashCode(byArray);
    }

    @NotNull
    public final byte[] getBytes() {
        return this.bytes;
    }

    public AccAddress(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        this.bytes = bytes;
    }

    public /* synthetic */ AccAddress(byte[] byArray, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            byArray = new byte[]{};
        }
        this(byArray);
    }

    public AccAddress() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0006J\u000e\u0010\u000f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0006J\u000e\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0006J\u000e\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0006J\u0016\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u0006J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0012R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Ltech/pylons/lib/types/AccAddress$Companion;", "", "()V", "addrLen", "", "bech32MainPrefix", "", "bech32PrefixAccAddr", "bech32PrefixAccPub", "prefixAccount", "prefixAddress", "prefixPublic", "accAddressFromBech32", "Ltech/pylons/lib/types/AccAddress;", "address", "accAddressFromHex", "bech32ifyAccPubEd25519", "pub", "", "bech32ifyAccPubSecp256k1", "getAccPubKeyBech32Ed25519", "pubkey", "getAccPubKeyBech32Secp256k1", "getFromBech32", "bech32str", "prefix", "verifyAddressFormat", "", "bz", "libpylons"})
    public static final class Companion {
        @NotNull
        public final AccAddress accAddressFromHex(@NotNull String address) {
            Intrinsics.checkNotNullParameter((Object)address, (String)"address");
            CharSequence charSequence = address;
            boolean bl = false;
            if (charSequence.length() == 0) {
                throw (Throwable)new Exception("decoding hex address failed: must provide an address");
            }
            byte[] byArray = Hex.decode((String)address);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"Hex.decode(address)");
            return new AccAddress(byArray);
        }

        public final void verifyAddressFormat(@NotNull byte[] bz) {
            Intrinsics.checkNotNullParameter((Object)bz, (String)"bz");
            String string = "how does this actually work";
            boolean bl = false;
            throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
        }

        @NotNull
        public final AccAddress accAddressFromBech32(@NotNull String address) {
            Intrinsics.checkNotNullParameter((Object)address, (String)"address");
            if (StringsKt.isBlank((CharSequence)address)) {
                return new AccAddress(new byte[0]);
            }
            byte[] bz = this.getFromBech32(address, "cosmos");
            this.verifyAddressFormat(bz);
            return new AccAddress(bz);
        }

        @NotNull
        public final byte[] getFromBech32(@NotNull String bech32str, @NotNull String prefix) {
            Intrinsics.checkNotNullParameter((Object)bech32str, (String)"bech32str");
            Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
            CharSequence charSequence = bech32str;
            boolean bl = false;
            if (charSequence.length() == 0) {
                throw (Throwable)new Exception("decoding Bech32 address failed: must provide an address");
            }
            Bech32Cosmos.UnencodedBech32Data decoded = Bech32Cosmos.Companion.decodeAndConvert(bech32str);
            if (Intrinsics.areEqual((Object)decoded.getHrp(), (Object)prefix) ^ true) {
                throw (Throwable)new Exception("invalid Bech32 prefix; expected " + prefix + ", got " + decoded.getHrp());
            }
            return decoded.getData();
        }

        @NotNull
        public final String bech32ifyAccPubEd25519(@NotNull byte[] pub) {
            Intrinsics.checkNotNullParameter((Object)pub, (String)AccAddress.prefixPublic);
            return Bech32Cosmos.Companion.convertAndEncode(AccAddress.bech32PrefixAccPub, AminoCompat.Companion.pubKeyEd25519(pub));
        }

        @NotNull
        public final String bech32ifyAccPubSecp256k1(@NotNull byte[] pub) {
            Intrinsics.checkNotNullParameter((Object)pub, (String)AccAddress.prefixPublic);
            return Bech32Cosmos.Companion.convertAndEncode(AccAddress.bech32PrefixAccPub, AminoCompat.Companion.pubKeySecp256k1(pub));
        }

        @NotNull
        public final byte[] getAccPubKeyBech32Ed25519(@NotNull String pubkey) {
            Intrinsics.checkNotNullParameter((Object)pubkey, (String)"pubkey");
            byte[] bz = this.getFromBech32(pubkey, AccAddress.bech32PrefixAccPub);
            return AminoCompat.Companion.stripPrefixBytes(bz);
        }

        @NotNull
        public final byte[] getAccPubKeyBech32Secp256k1(@NotNull String pubkey) {
            Intrinsics.checkNotNullParameter((Object)pubkey, (String)"pubkey");
            byte[] bz = this.getFromBech32(pubkey, AccAddress.bech32PrefixAccPub);
            return AminoCompat.Companion.stripPrefixBytes(bz);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

