/*
 * Decompiled with CFR 0.152.
 */
package tech.pylons.lib;

import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.MutableBytes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kethereum.bip32.BIP32;
import org.kethereum.bip32.model.ExtendedKey;
import org.kethereum.bip39.MnemonicKt;
import org.kethereum.bip39.wordlists.WordlistKt;
import org.spongycastle.jce.ECNamedCurveTable;
import org.spongycastle.jce.spec.ECNamedCurveParameterSpec;
import org.spongycastle.math.ec.ECFieldElement;
import org.spongycastle.math.ec.ECPoint;
import tech.pylons.lib.types.AminoCompat;
import tech.pylons.lib.types.Bech32Cosmos;
import tech.pylons.lib.types.PylonsSECP256K1;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0016\u0010\t\u001a\u00020\u0006\u00f8\u0001\u0000\u00f8\u0001\u0002\u00f8\u0001\u0001\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0004J\u000e\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0017\u001a\u00020\u00132\b\u0010\u0018\u001a\u0004\u0018\u00010\u0004J\u000e\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u0015\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u001b"}, d2={"Ltech/pylons/lib/PubKeyUtil;", "", "()V", "generateKeyPairFromMnemonic", "Ltech/pylons/lib/types/PylonsSECP256K1$KeyPair;", "mnemonic", "Lorg/kethereum/bip39/model/MnemonicWords;", "generateKeyPairFromMnemonic-z8tBqSw", "(Ljava/util/List;)Ltech/pylons/lib/types/PylonsSECP256K1$KeyPair;", "generateMnemonic", "generateMnemonic-CHoocwo", "()Ljava/util/List;", "getAddressFromKeyPair", "Lorg/apache/tuweni/bytes/Bytes;", "keyPair", "getAddressFromPubkey", "key", "Ltech/pylons/lib/types/PylonsSECP256K1$PublicKey;", "getAddressString", "", "addr", "", "getCompressedPubkey", "getLogMsgForKeys", "kp", "getUncompressedPubkey", "bytes", "libpylons"})
public final class PubKeyUtil {
    @NotNull
    public static final PubKeyUtil INSTANCE;

    @NotNull
    public final List<? extends String> generateMnemonic-CHoocwo() {
        return MnemonicKt.dirtyPhraseToMnemonicWords((String)MnemonicKt.generateMnemonic((int)128, (List)WordlistKt.getWORDLIST_ENGLISH()));
    }

    @NotNull
    public final String getLogMsgForKeys(@Nullable PylonsSECP256K1.KeyPair kp) {
        String string;
        PylonsSECP256K1.KeyPair keyPair = kp;
        if (keyPair == null) {
            string = "null";
        } else {
            StringBuilder stringBuilder = new StringBuilder().append("{\"pubKey\":\"");
            PylonsSECP256K1.PublicKey publicKey = kp.publicKey();
            Intrinsics.checkNotNullExpressionValue((Object)publicKey, (String)"kp.publicKey()");
            string = stringBuilder.append(this.getCompressedPubkey(publicKey).toHexString()).append("\"}").toString();
        }
        return string;
    }

    @NotNull
    public final PylonsSECP256K1.KeyPair generateKeyPairFromMnemonic-z8tBqSw(@NotNull List<? extends String> mnemonic) {
        PylonsSECP256K1.KeyPair kp;
        Intrinsics.checkNotNullParameter(mnemonic, (String)"mnemonic");
        byte[] seed = MnemonicKt.toSeed-d_no5WQ(mnemonic, (String)"");
        ExtendedKey key = BIP32.toKey-siqfMno$default((byte[])seed, (String)"m/44'/118'/0'/0/0", (boolean)false, (int)2, null);
        BigInteger rawPrivKey = key.getKeyPair().getPrivateKey-V6oYYD4();
        PylonsSECP256K1.KeyPair keyPair = kp = PylonsSECP256K1.KeyPair.fromSecretKey(PylonsSECP256K1.SecretKey.fromInteger(rawPrivKey));
        Intrinsics.checkNotNullExpressionValue((Object)keyPair, (String)"kp");
        return keyPair;
    }

    @NotNull
    public final PylonsSECP256K1.PublicKey getUncompressedPubkey(@NotNull byte[] bytes) {
        ECPoint point;
        ECNamedCurveParameterSpec spec;
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        ECNamedCurveParameterSpec eCNamedCurveParameterSpec = spec = ECNamedCurveTable.getParameterSpec((String)"secp256k1");
        Intrinsics.checkNotNullExpressionValue((Object)eCNamedCurveParameterSpec, (String)"spec");
        ECPoint eCPoint = point = eCNamedCurveParameterSpec.getCurve().decodePoint(bytes);
        Intrinsics.checkNotNullExpressionValue((Object)eCPoint, (String)"point");
        ECFieldElement eCFieldElement = eCPoint.getXCoord();
        Intrinsics.checkNotNullExpressionValue((Object)eCFieldElement, (String)"point.xCoord");
        byte[] x = eCFieldElement.getEncoded();
        ECFieldElement eCFieldElement2 = point.getYCoord();
        Intrinsics.checkNotNullExpressionValue((Object)eCFieldElement2, (String)"point.yCoord");
        byte[] y = eCFieldElement2.getEncoded();
        Intrinsics.checkNotNullExpressionValue((Object)x, (String)"x");
        Intrinsics.checkNotNullExpressionValue((Object)y, (String)"y");
        PylonsSECP256K1.PublicKey publicKey = PylonsSECP256K1.PublicKey.fromBytes(Bytes.wrap((byte[])ArraysKt.plus((byte[])x, (byte[])y)));
        Intrinsics.checkNotNullExpressionValue((Object)publicKey, (String)"PylonsSECP256K1.PublicKe\u2026mBytes(Bytes.wrap(x + y))");
        return publicKey;
    }

    @NotNull
    public final Bytes getCompressedPubkey(@NotNull PylonsSECP256K1.PublicKey key) {
        int n;
        ECPoint ecPoint;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        ECPoint eCPoint = ecPoint = key.asEcPoint();
        Intrinsics.checkNotNullExpressionValue((Object)eCPoint, (String)"ecPoint");
        Bytes xBytes = Bytes.wrap((byte[])eCPoint.getXCoord().toBigInteger().toByteArray()).trimLeadingZeros();
        String string = ecPoint.getYCoord().toBigInteger().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ecPoint.yCoord.toBigInteger().toString()");
        String yStr = string;
        String string2 = ecPoint.getXCoord().toBigInteger().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"ecPoint.xCoord.toBigInteger().toString()");
        String xStr = string2;
        BigInteger bigInteger = ecPoint.getYCoord().toBigInteger();
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"ecPoint.yCoord.toBigInteger()");
        BigInteger bigInteger2 = bigInteger;
        int n2 = 2;
        boolean bl = false;
        BigInteger bigInteger3 = BigInteger.valueOf(n2);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger3, (String)"BigInteger.valueOf(this.toLong())");
        BigInteger bigInteger4 = bigInteger3;
        bl = false;
        BigInteger bigInteger5 = bigInteger2.remainder(bigInteger4);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger5, (String)"this.remainder(other)");
        int n3 = 0;
        boolean bl2 = false;
        BigInteger bigInteger6 = BigInteger.valueOf(n3);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger6, (String)"BigInteger.valueOf(this.toLong())");
        boolean bl3 = Intrinsics.areEqual((Object)bigInteger5, (Object)bigInteger6);
        if (bl3) {
            n = 2;
        } else if (!bl3) {
            n = 3;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        int prefix = n;
        MutableBytes bytes = MutableBytes.wrap((byte[])new byte[33]);
        bytes.set(0, (byte)prefix);
        xBytes.copyTo(bytes, 1);
        MutableBytes mutableBytes = bytes;
        Intrinsics.checkNotNullExpressionValue((Object)mutableBytes, (String)"bytes");
        return (Bytes)mutableBytes;
    }

    @NotNull
    public final Bytes getAddressFromPubkey(@NotNull PylonsSECP256K1.PublicKey key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Bytes pubkey = this.getCompressedPubkey(key);
        byte[] sha = MessageDigest.getInstance("SHA-256").digest(pubkey.toArray());
        byte[] ripEmd = MessageDigest.getInstance("RIPEMD160").digest(sha);
        Bytes bytes = Bytes.wrap((byte[])ripEmd);
        Intrinsics.checkNotNullExpressionValue((Object)bytes, (String)"Bytes.wrap(ripEmd)");
        return bytes;
    }

    @NotNull
    public final Bytes getAddressFromKeyPair(@NotNull PylonsSECP256K1.KeyPair keyPair) {
        Intrinsics.checkNotNullParameter((Object)keyPair, (String)"keyPair");
        PylonsSECP256K1.PublicKey publicKey = keyPair.publicKey();
        Intrinsics.checkNotNullExpressionValue((Object)publicKey, (String)"keyPair.publicKey()");
        return this.getAddressFromPubkey(publicKey);
    }

    @NotNull
    public final String getAddressString(@NotNull byte[] addr) {
        Intrinsics.checkNotNullParameter((Object)addr, (String)"addr");
        return Bech32Cosmos.Companion.convertAndEncode("cosmos", AminoCompat.Companion.accAddress(addr));
    }

    private PubKeyUtil() {
    }

    static {
        PubKeyUtil pubKeyUtil;
        INSTANCE = pubKeyUtil = new PubKeyUtil();
    }
}

