/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.cms;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import org.spongycastle.asn1.ASN1Encodable;
import org.spongycastle.asn1.ASN1ObjectIdentifier;
import org.spongycastle.asn1.ASN1Set;
import org.spongycastle.asn1.DEROctetString;
import org.spongycastle.asn1.DERSet;
import org.spongycastle.asn1.cms.Attribute;
import org.spongycastle.asn1.cms.AttributeTable;
import org.spongycastle.asn1.cms.CMSAlgorithmProtection;
import org.spongycastle.asn1.cms.CMSAttributes;
import org.spongycastle.asn1.x509.AlgorithmIdentifier;
import org.spongycastle.cms.CMSAttributeTableGenerator;

public class DefaultAuthenticatedAttributeTableGenerator
implements CMSAttributeTableGenerator {
    private final Hashtable table;

    public DefaultAuthenticatedAttributeTableGenerator() {
        this.table = new Hashtable();
    }

    public DefaultAuthenticatedAttributeTableGenerator(AttributeTable attributeTable) {
        this.table = attributeTable != null ? attributeTable.toHashtable() : new Hashtable();
    }

    protected Hashtable createStandardAttributeTable(Map parameters) {
        Attribute attr;
        Hashtable std = new Hashtable();
        Enumeration en = this.table.keys();
        while (en.hasMoreElements()) {
            Object key = en.nextElement();
            std.put(key, this.table.get(key));
        }
        if (!std.containsKey(CMSAttributes.contentType)) {
            ASN1ObjectIdentifier contentType = ASN1ObjectIdentifier.getInstance(parameters.get("contentType"));
            attr = new Attribute(CMSAttributes.contentType, (ASN1Set)new DERSet((ASN1Encodable)contentType));
            std.put(attr.getAttrType(), attr);
        }
        if (!std.containsKey(CMSAttributes.messageDigest)) {
            byte[] messageDigest = (byte[])parameters.get("digest");
            attr = new Attribute(CMSAttributes.messageDigest, (ASN1Set)new DERSet((ASN1Encodable)new DEROctetString(messageDigest)));
            std.put(attr.getAttrType(), attr);
        }
        if (!std.contains(CMSAttributes.cmsAlgorithmProtect)) {
            Attribute attr2 = new Attribute(CMSAttributes.cmsAlgorithmProtect, (ASN1Set)new DERSet((ASN1Encodable)new CMSAlgorithmProtection((AlgorithmIdentifier)parameters.get("digestAlgID"), 2, (AlgorithmIdentifier)parameters.get("macAlgID"))));
            std.put(attr2.getAttrType(), attr2);
        }
        return std;
    }

    public AttributeTable getAttributes(Map parameters) {
        return new AttributeTable(this.createStandardAttributeTable(parameters));
    }
}

