/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.crypto.params;

import org.spongycastle.crypto.params.ECDomainParameters;
import org.spongycastle.crypto.params.ECKeyParameters;
import org.spongycastle.math.ec.ECPoint;

public class ECPublicKeyParameters
extends ECKeyParameters {
    private final ECPoint Q;

    public ECPublicKeyParameters(ECPoint Q, ECDomainParameters params) {
        super(false, params);
        this.Q = this.validate(Q);
    }

    private ECPoint validate(ECPoint q) {
        if (q == null) {
            throw new IllegalArgumentException("point has null value");
        }
        if (q.isInfinity()) {
            throw new IllegalArgumentException("point at infinity");
        }
        if (!(q = q.normalize()).isValid()) {
            throw new IllegalArgumentException("point not on curve");
        }
        return q;
    }

    public ECPoint getQ() {
        return this.Q;
    }
}

