/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.openpgp.operator.jcajce;

import java.io.InputStream;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Signature;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.KeyAgreement;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.spongycastle.jcajce.util.JcaJceHelper;
import org.spongycastle.openpgp.PGPException;
import org.spongycastle.openpgp.PGPUtil;
import org.spongycastle.openpgp.operator.PGPDataDecryptor;
import org.spongycastle.openpgp.operator.PGPDigestCalculator;
import org.spongycastle.openpgp.operator.jcajce.SHA1PGPDigestCalculator;

class OperatorHelper {
    private JcaJceHelper helper;

    OperatorHelper(JcaJceHelper helper) {
        this.helper = helper;
    }

    MessageDigest createDigest(int algorithm) throws GeneralSecurityException, PGPException {
        MessageDigest dig = this.helper.createDigest(PGPUtil.getDigestName(algorithm));
        return dig;
    }

    KeyFactory createKeyFactory(String algorithm) throws GeneralSecurityException, PGPException {
        return this.helper.createKeyFactory(algorithm);
    }

    public KeyAgreement createKeyAgreement(String algorithm) throws GeneralSecurityException {
        return this.helper.createKeyAgreement(algorithm);
    }

    public KeyPairGenerator createKeyPairGenerator(String algorithm) throws GeneralSecurityException {
        return this.helper.createKeyPairGenerator(algorithm);
    }

    PGPDataDecryptor createDataDecryptor(boolean withIntegrityPacket, int encAlgorithm, byte[] key) throws PGPException {
        try {
            SecretKeySpec secretKey = new SecretKeySpec(key, PGPUtil.getSymmetricCipherName(encAlgorithm));
            final Cipher c = this.createStreamCipher(encAlgorithm, withIntegrityPacket);
            if (withIntegrityPacket) {
                byte[] iv = new byte[c.getBlockSize()];
                c.init(2, (Key)secretKey, new IvParameterSpec(iv));
            } else {
                c.init(2, secretKey);
            }
            return new PGPDataDecryptor(){

                public InputStream getInputStream(InputStream in) {
                    return new CipherInputStream(in, c);
                }

                public int getBlockSize() {
                    return c.getBlockSize();
                }

                public PGPDigestCalculator getIntegrityCalculator() {
                    return new SHA1PGPDigestCalculator();
                }
            };
        }
        catch (PGPException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PGPException("Exception creating cipher", e);
        }
    }

    Cipher createStreamCipher(int encAlgorithm, boolean withIntegrityPacket) throws PGPException {
        String mode = withIntegrityPacket ? "CFB" : "OpenPGPCFB";
        String cName = PGPUtil.getSymmetricCipherName(encAlgorithm) + "/" + mode + "/NoPadding";
        return this.createCipher(cName);
    }

    Cipher createCipher(String cipherName) throws PGPException {
        try {
            return this.helper.createCipher(cipherName);
        }
        catch (GeneralSecurityException e) {
            throw new PGPException("cannot create cipher: " + e.getMessage(), e);
        }
    }

    Cipher createPublicKeyCipher(int encAlgorithm) throws PGPException {
        switch (encAlgorithm) {
            case 1: 
            case 2: {
                return this.createCipher("RSA/ECB/PKCS1Padding");
            }
            case 16: 
            case 20: {
                return this.createCipher("ElGamal/ECB/PKCS1Padding");
            }
            case 17: {
                throw new PGPException("Can't use DSA for encryption.");
            }
            case 19: {
                throw new PGPException("Can't use ECDSA for encryption.");
            }
        }
        throw new PGPException("unknown asymmetric algorithm: " + encAlgorithm);
    }

    Cipher createKeyWrapper(int encAlgorithm) throws PGPException {
        try {
            switch (encAlgorithm) {
                case 7: 
                case 8: 
                case 9: {
                    return this.helper.createCipher("AESWrap");
                }
                case 11: 
                case 12: 
                case 13: {
                    return this.helper.createCipher("CamelliaWrap");
                }
            }
            throw new PGPException("unknown wrap algorithm: " + encAlgorithm);
        }
        catch (GeneralSecurityException e) {
            throw new PGPException("cannot create cipher: " + e.getMessage(), e);
        }
    }

    private Signature createSignature(String cipherName) throws PGPException {
        try {
            return this.helper.createSignature(cipherName);
        }
        catch (GeneralSecurityException e) {
            throw new PGPException("cannot create signature: " + e.getMessage(), e);
        }
    }

    public Signature createSignature(int keyAlgorithm, int hashAlgorithm) throws PGPException {
        String encAlg;
        switch (keyAlgorithm) {
            case 1: 
            case 3: {
                encAlg = "RSA";
                break;
            }
            case 17: {
                encAlg = "DSA";
                break;
            }
            case 16: 
            case 20: {
                encAlg = "ElGamal";
                break;
            }
            case 19: {
                encAlg = "ECDSA";
                break;
            }
            default: {
                throw new PGPException("unknown algorithm tag in signature:" + keyAlgorithm);
            }
        }
        return this.createSignature(PGPUtil.getDigestName(hashAlgorithm) + "with" + encAlg);
    }

    public AlgorithmParameters createAlgorithmParameters(String algorithm) throws NoSuchProviderException, NoSuchAlgorithmException {
        return this.helper.createAlgorithmParameters(algorithm);
    }
}

