/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.openpgp.operator.bc;

import java.io.IOException;
import org.spongycastle.asn1.ASN1ObjectIdentifier;
import org.spongycastle.asn1.nist.NISTNamedCurves;
import org.spongycastle.asn1.x9.X9ECParameters;
import org.spongycastle.bcpg.ECDHPublicBCPGKey;
import org.spongycastle.bcpg.ECSecretBCPGKey;
import org.spongycastle.crypto.AsymmetricBlockCipher;
import org.spongycastle.crypto.BlockCipher;
import org.spongycastle.crypto.BufferedAsymmetricBlockCipher;
import org.spongycastle.crypto.CipherParameters;
import org.spongycastle.crypto.InvalidCipherTextException;
import org.spongycastle.crypto.Wrapper;
import org.spongycastle.crypto.params.AsymmetricKeyParameter;
import org.spongycastle.crypto.params.ElGamalPrivateKeyParameters;
import org.spongycastle.crypto.params.KeyParameter;
import org.spongycastle.math.ec.ECPoint;
import org.spongycastle.openpgp.PGPException;
import org.spongycastle.openpgp.PGPPrivateKey;
import org.spongycastle.openpgp.operator.PGPDataDecryptor;
import org.spongycastle.openpgp.operator.PGPPad;
import org.spongycastle.openpgp.operator.PublicKeyDataDecryptorFactory;
import org.spongycastle.openpgp.operator.RFC6637Utils;
import org.spongycastle.openpgp.operator.bc.BcImplProvider;
import org.spongycastle.openpgp.operator.bc.BcKeyFingerprintCalculator;
import org.spongycastle.openpgp.operator.bc.BcPGPDigestCalculatorProvider;
import org.spongycastle.openpgp.operator.bc.BcPGPKeyConverter;
import org.spongycastle.openpgp.operator.bc.BcUtil;
import org.spongycastle.openpgp.operator.bc.RFC6637KDFCalculator;

public class BcPublicKeyDataDecryptorFactory
implements PublicKeyDataDecryptorFactory {
    private BcPGPKeyConverter keyConverter = new BcPGPKeyConverter();
    private PGPPrivateKey privKey;

    public BcPublicKeyDataDecryptorFactory(PGPPrivateKey privKey) {
        this.privKey = privKey;
    }

    public byte[] recoverSessionData(int keyAlgorithm, byte[][] secKeyData) throws PGPException {
        try {
            if (keyAlgorithm != 18) {
                AsymmetricBlockCipher c = BcImplProvider.createPublicKeyCipher(keyAlgorithm);
                AsymmetricKeyParameter key = this.keyConverter.getPrivateKey(this.privKey);
                BufferedAsymmetricBlockCipher c1 = new BufferedAsymmetricBlockCipher(c);
                c1.init(false, (CipherParameters)key);
                if (keyAlgorithm == 2 || keyAlgorithm == 1) {
                    byte[] bi = secKeyData[0];
                    c1.processBytes(bi, 2, bi.length - 2);
                } else {
                    BcPGPKeyConverter converter = new BcPGPKeyConverter();
                    ElGamalPrivateKeyParameters parms = (ElGamalPrivateKeyParameters)converter.getPrivateKey(this.privKey);
                    int size = (parms.getParameters().getP().bitLength() + 7) / 8;
                    byte[] tmp = new byte[size];
                    byte[] bi = secKeyData[0];
                    if (bi.length - 2 > size) {
                        c1.processBytes(bi, 3, bi.length - 3);
                    } else {
                        System.arraycopy(bi, 2, tmp, tmp.length - (bi.length - 2), bi.length - 2);
                        c1.processBytes(tmp, 0, tmp.length);
                    }
                    bi = secKeyData[1];
                    for (int i = 0; i != tmp.length; ++i) {
                        tmp[i] = 0;
                    }
                    if (bi.length - 2 > size) {
                        c1.processBytes(bi, 3, bi.length - 3);
                    } else {
                        System.arraycopy(bi, 2, tmp, tmp.length - (bi.length - 2), bi.length - 2);
                        c1.processBytes(tmp, 0, tmp.length);
                    }
                }
                return c1.doFinal();
            }
            ECDHPublicBCPGKey ecKey = (ECDHPublicBCPGKey)this.privKey.getPublicKeyPacket().getKey();
            X9ECParameters x9Params = NISTNamedCurves.getByOID((ASN1ObjectIdentifier)ecKey.getCurveOID());
            byte[] enc = secKeyData[0];
            int pLen = (((enc[0] & 0xFF) << 8) + (enc[1] & 0xFF) + 7) / 8;
            byte[] pEnc = new byte[pLen];
            System.arraycopy(enc, 2, pEnc, 0, pLen);
            byte[] keyEnc = new byte[enc[pLen + 2]];
            System.arraycopy(enc, 2 + pLen + 1, keyEnc, 0, keyEnc.length);
            Wrapper c = BcImplProvider.createWrapper(ecKey.getSymmetricKeyAlgorithm());
            ECPoint S = x9Params.getCurve().decodePoint(pEnc).multiply(((ECSecretBCPGKey)this.privKey.getPrivateKeyDataPacket()).getX()).normalize();
            RFC6637KDFCalculator rfc6637KDFCalculator = new RFC6637KDFCalculator(new BcPGPDigestCalculatorProvider().get(ecKey.getHashAlgorithm()), ecKey.getSymmetricKeyAlgorithm());
            KeyParameter key = new KeyParameter(rfc6637KDFCalculator.createKey(S, RFC6637Utils.createUserKeyingMaterial(this.privKey.getPublicKeyPacket(), new BcKeyFingerprintCalculator())));
            c.init(false, (CipherParameters)key);
            return PGPPad.unpadSessionData(c.unwrap(keyEnc, 0, keyEnc.length));
        }
        catch (IOException e) {
            throw new PGPException("exception creating user keying material: " + e.getMessage(), e);
        }
        catch (InvalidCipherTextException e) {
            throw new PGPException("exception encrypting session info: " + e.getMessage(), (Exception)((Object)e));
        }
    }

    public PGPDataDecryptor createDataDecryptor(boolean withIntegrityPacket, int encAlgorithm, byte[] key) throws PGPException {
        BlockCipher engine = BcImplProvider.createBlockCipher(encAlgorithm);
        return BcUtil.createDataDecryptor(withIntegrityPacket, engine, key);
    }
}

