/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.openpgp.operator.bc;

import org.spongycastle.crypto.AsymmetricBlockCipher;
import org.spongycastle.crypto.BlockCipher;
import org.spongycastle.crypto.DSA;
import org.spongycastle.crypto.Digest;
import org.spongycastle.crypto.Signer;
import org.spongycastle.crypto.Wrapper;
import org.spongycastle.crypto.digests.MD2Digest;
import org.spongycastle.crypto.digests.MD5Digest;
import org.spongycastle.crypto.digests.RIPEMD160Digest;
import org.spongycastle.crypto.digests.SHA1Digest;
import org.spongycastle.crypto.digests.SHA224Digest;
import org.spongycastle.crypto.digests.SHA256Digest;
import org.spongycastle.crypto.digests.SHA384Digest;
import org.spongycastle.crypto.digests.SHA512Digest;
import org.spongycastle.crypto.digests.TigerDigest;
import org.spongycastle.crypto.encodings.PKCS1Encoding;
import org.spongycastle.crypto.engines.AESEngine;
import org.spongycastle.crypto.engines.BlowfishEngine;
import org.spongycastle.crypto.engines.CAST5Engine;
import org.spongycastle.crypto.engines.CamelliaEngine;
import org.spongycastle.crypto.engines.DESEngine;
import org.spongycastle.crypto.engines.DESedeEngine;
import org.spongycastle.crypto.engines.ElGamalEngine;
import org.spongycastle.crypto.engines.IDEAEngine;
import org.spongycastle.crypto.engines.RFC3394WrapEngine;
import org.spongycastle.crypto.engines.RSABlindedEngine;
import org.spongycastle.crypto.engines.TwofishEngine;
import org.spongycastle.crypto.signers.DSADigestSigner;
import org.spongycastle.crypto.signers.DSASigner;
import org.spongycastle.crypto.signers.ECDSASigner;
import org.spongycastle.crypto.signers.RSADigestSigner;
import org.spongycastle.openpgp.PGPException;

class BcImplProvider {
    BcImplProvider() {
    }

    static Digest createDigest(int algorithm) throws PGPException {
        switch (algorithm) {
            case 2: {
                return new SHA1Digest();
            }
            case 11: {
                return new SHA224Digest();
            }
            case 8: {
                return new SHA256Digest();
            }
            case 9: {
                return new SHA384Digest();
            }
            case 10: {
                return new SHA512Digest();
            }
            case 5: {
                return new MD2Digest();
            }
            case 1: {
                return new MD5Digest();
            }
            case 3: {
                return new RIPEMD160Digest();
            }
            case 6: {
                return new TigerDigest();
            }
        }
        throw new PGPException("cannot recognise digest");
    }

    static Signer createSigner(int keyAlgorithm, int hashAlgorithm) throws PGPException {
        switch (keyAlgorithm) {
            case 1: 
            case 3: {
                return new RSADigestSigner(BcImplProvider.createDigest(hashAlgorithm));
            }
            case 17: {
                return new DSADigestSigner((DSA)new DSASigner(), BcImplProvider.createDigest(hashAlgorithm));
            }
            case 19: {
                return new DSADigestSigner((DSA)new ECDSASigner(), BcImplProvider.createDigest(hashAlgorithm));
            }
        }
        throw new PGPException("cannot recognise keyAlgorithm: " + keyAlgorithm);
    }

    static BlockCipher createBlockCipher(int encAlgorithm) throws PGPException {
        AESEngine engine;
        switch (encAlgorithm) {
            case 7: 
            case 8: 
            case 9: {
                engine = new AESEngine();
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                engine = new CamelliaEngine();
                break;
            }
            case 4: {
                engine = new BlowfishEngine();
                break;
            }
            case 3: {
                engine = new CAST5Engine();
                break;
            }
            case 6: {
                engine = new DESEngine();
                break;
            }
            case 1: {
                engine = new IDEAEngine();
                break;
            }
            case 10: {
                engine = new TwofishEngine();
                break;
            }
            case 2: {
                engine = new DESedeEngine();
                break;
            }
            default: {
                throw new PGPException("cannot recognise cipher");
            }
        }
        return engine;
    }

    static Wrapper createWrapper(int encAlgorithm) throws PGPException {
        switch (encAlgorithm) {
            case 7: 
            case 8: 
            case 9: {
                return new RFC3394WrapEngine((BlockCipher)new AESEngine());
            }
            case 11: 
            case 12: 
            case 13: {
                return new RFC3394WrapEngine((BlockCipher)new CamelliaEngine());
            }
        }
        throw new PGPException("unknown wrap algorithm: " + encAlgorithm);
    }

    static AsymmetricBlockCipher createPublicKeyCipher(int encAlgorithm) throws PGPException {
        PKCS1Encoding c;
        switch (encAlgorithm) {
            case 1: 
            case 2: {
                c = new PKCS1Encoding((AsymmetricBlockCipher)new RSABlindedEngine());
                break;
            }
            case 16: 
            case 20: {
                c = new PKCS1Encoding((AsymmetricBlockCipher)new ElGamalEngine());
                break;
            }
            case 17: {
                throw new PGPException("Can't use DSA for encryption.");
            }
            case 19: {
                throw new PGPException("Can't use ECDSA for encryption.");
            }
            case 18: {
                throw new PGPException("Not implemented.");
            }
            default: {
                throw new PGPException("unknown asymmetric algorithm: " + encAlgorithm);
            }
        }
        return c;
    }
}

