/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.openpgp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.spongycastle.bcpg.BCPGInputStream;
import org.spongycastle.bcpg.PublicKeyPacket;
import org.spongycastle.bcpg.TrustPacket;
import org.spongycastle.openpgp.PGPException;
import org.spongycastle.openpgp.PGPKeyRing;
import org.spongycastle.openpgp.PGPPublicKey;
import org.spongycastle.openpgp.PGPSignature;
import org.spongycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.spongycastle.util.Arrays;
import org.spongycastle.util.Iterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PGPPublicKeyRing
extends PGPKeyRing
implements Iterable<PGPPublicKey> {
    List keys;

    public PGPPublicKeyRing(byte[] encoding, KeyFingerPrintCalculator fingerPrintCalculator) throws IOException {
        this(new ByteArrayInputStream(encoding), fingerPrintCalculator);
    }

    PGPPublicKeyRing(List pubKeys) {
        this.keys = pubKeys;
    }

    public PGPPublicKeyRing(InputStream in, KeyFingerPrintCalculator fingerPrintCalculator) throws IOException {
        this.keys = new ArrayList();
        BCPGInputStream pIn = PGPPublicKeyRing.wrap(in);
        int initialTag = pIn.nextPacketTag();
        if (initialTag != 6 && initialTag != 14) {
            throw new IOException("public key ring doesn't start with public key tag: tag 0x" + Integer.toHexString(initialTag));
        }
        PublicKeyPacket pubPk = (PublicKeyPacket)pIn.readPacket();
        TrustPacket trustPk = PGPPublicKeyRing.readOptionalTrustPacket(pIn);
        List keySigs = PGPPublicKeyRing.readSignaturesAndTrust(pIn);
        ArrayList ids = new ArrayList();
        ArrayList idTrusts = new ArrayList();
        ArrayList idSigs = new ArrayList();
        PGPPublicKeyRing.readUserIDs(pIn, ids, idTrusts, idSigs);
        try {
            this.keys.add(new PGPPublicKey(pubPk, trustPk, keySigs, ids, idTrusts, idSigs, fingerPrintCalculator));
            while (pIn.nextPacketTag() == 14) {
                this.keys.add(PGPPublicKeyRing.readSubkey(pIn, fingerPrintCalculator));
            }
        }
        catch (PGPException e) {
            throw new IOException("processing exception: " + e.toString());
        }
    }

    @Override
    public PGPPublicKey getPublicKey() {
        return (PGPPublicKey)this.keys.get(0);
    }

    @Override
    public PGPPublicKey getPublicKey(long keyID) {
        for (int i = 0; i != this.keys.size(); ++i) {
            PGPPublicKey k = (PGPPublicKey)this.keys.get(i);
            if (keyID != k.getKeyID()) continue;
            return k;
        }
        return null;
    }

    @Override
    public PGPPublicKey getPublicKey(byte[] fingerprint) {
        for (int i = 0; i != this.keys.size(); ++i) {
            PGPPublicKey k = (PGPPublicKey)this.keys.get(i);
            if (!Arrays.areEqual((byte[])fingerprint, (byte[])k.getFingerprint())) continue;
            return k;
        }
        return null;
    }

    @Override
    public Iterator<PGPPublicKey> getKeysWithSignaturesBy(long keyID) {
        ArrayList<PGPPublicKey> keysWithSigs = new ArrayList<PGPPublicKey>();
        for (int i = 0; i != this.keys.size(); ++i) {
            PGPPublicKey k = (PGPPublicKey)this.keys.get(i);
            Iterator<PGPSignature> sigIt = k.getSignaturesForKeyID(keyID);
            if (!sigIt.hasNext()) continue;
            keysWithSigs.add(k);
        }
        return keysWithSigs.iterator();
    }

    @Override
    public Iterator<PGPPublicKey> getPublicKeys() {
        return Collections.unmodifiableList(this.keys).iterator();
    }

    public Iterator<PGPPublicKey> iterator() {
        return this.getPublicKeys();
    }

    @Override
    public byte[] getEncoded() throws IOException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        this.encode(bOut);
        return bOut.toByteArray();
    }

    public byte[] getEncoded(boolean forTransfer) throws IOException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        this.encode(bOut, forTransfer);
        return bOut.toByteArray();
    }

    @Override
    public void encode(OutputStream outStream) throws IOException {
        this.encode(outStream, false);
    }

    public void encode(OutputStream outStream, boolean forTransfer) throws IOException {
        for (int i = 0; i != this.keys.size(); ++i) {
            PGPPublicKey k = (PGPPublicKey)this.keys.get(i);
            k.encode(outStream, forTransfer);
        }
    }

    public static PGPPublicKeyRing insertPublicKey(PGPPublicKeyRing pubRing, PGPPublicKey pubKey) {
        ArrayList<PGPPublicKey> keys = new ArrayList<PGPPublicKey>(pubRing.keys);
        boolean found = false;
        boolean masterFound = false;
        for (int i = 0; i != keys.size(); ++i) {
            PGPPublicKey key = (PGPPublicKey)keys.get(i);
            if (key.getKeyID() == pubKey.getKeyID()) {
                found = true;
                keys.set(i, pubKey);
            }
            if (!key.isMasterKey()) continue;
            masterFound = true;
        }
        if (!found) {
            if (pubKey.isMasterKey()) {
                if (masterFound) {
                    throw new IllegalArgumentException("cannot add a master key to a ring that already has one");
                }
                keys.add(0, pubKey);
            } else {
                keys.add(pubKey);
            }
        }
        return new PGPPublicKeyRing(keys);
    }

    public static PGPPublicKeyRing removePublicKey(PGPPublicKeyRing pubRing, PGPPublicKey pubKey) {
        ArrayList keys = new ArrayList(pubRing.keys);
        boolean found = false;
        for (int i = 0; i < keys.size(); ++i) {
            PGPPublicKey key = (PGPPublicKey)keys.get(i);
            if (key.getKeyID() != pubKey.getKeyID()) continue;
            found = true;
            keys.remove(i);
        }
        if (!found) {
            return null;
        }
        return new PGPPublicKeyRing(keys);
    }

    static PGPPublicKey readSubkey(BCPGInputStream in, KeyFingerPrintCalculator fingerPrintCalculator) throws IOException, PGPException {
        PublicKeyPacket pk = (PublicKeyPacket)in.readPacket();
        TrustPacket kTrust = PGPPublicKeyRing.readOptionalTrustPacket(in);
        List sigList = PGPPublicKeyRing.readSignaturesAndTrust(in);
        return new PGPPublicKey(pk, kTrust, sigList, fingerPrintCalculator);
    }
}

