/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.bcpg;

import java.io.IOException;
import java.io.OutputStream;
import org.spongycastle.util.Arrays;

public class UserAttributeSubpacket {
    int type;
    private boolean forceLongLength;
    protected byte[] data;

    protected UserAttributeSubpacket(int type, byte[] data) {
        this(type, false, data);
    }

    protected UserAttributeSubpacket(int type, boolean forceLongLength, byte[] data) {
        this.type = type;
        this.forceLongLength = forceLongLength;
        this.data = data;
    }

    public int getType() {
        return this.type;
    }

    public byte[] getData() {
        return this.data;
    }

    public void encode(OutputStream out) throws IOException {
        int bodyLen = this.data.length + 1;
        if (bodyLen < 192 && !this.forceLongLength) {
            out.write((byte)bodyLen);
        } else if (bodyLen <= 8383 && !this.forceLongLength) {
            out.write((byte)(((bodyLen -= 192) >> 8 & 0xFF) + 192));
            out.write((byte)bodyLen);
        } else {
            out.write(255);
            out.write((byte)(bodyLen >> 24));
            out.write((byte)(bodyLen >> 16));
            out.write((byte)(bodyLen >> 8));
            out.write((byte)bodyLen);
        }
        out.write(this.type);
        out.write(this.data);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UserAttributeSubpacket)) {
            return false;
        }
        UserAttributeSubpacket other = (UserAttributeSubpacket)o;
        return this.type == other.type && Arrays.areEqual((byte[])this.data, (byte[])other.data);
    }

    public int hashCode() {
        return this.type ^ Arrays.hashCode((byte[])this.data);
    }
}

