/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refaster.runner;

import com.google.auto.service.AutoService;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableRangeSet;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import com.google.errorprone.BugPattern;
import com.google.errorprone.CodeTransformer;
import com.google.errorprone.CompositeCodeTransformer;
import com.google.errorprone.ErrorProneFlags;
import com.google.errorprone.ErrorProneOptions;
import com.google.errorprone.SubContext;
import com.google.errorprone.VisitorState;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Replacement;
import com.google.errorprone.matchers.Description;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.tools.javac.tree.EndPosTable;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JCDiagnostic;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.inject.Inject;
import tech.picnic.errorprone.refaster.runner.CodeTransformers;

@BugPattern(summary="Write idiomatic code when possible", linkType=BugPattern.LinkType.NONE, severity=BugPattern.SeverityLevel.SUGGESTION, tags={"Simplification"})
@AutoService(value={BugChecker.class})
public final class Refaster
extends BugChecker
implements BugChecker.CompilationUnitTreeMatcher {
    public static final String INCLUDED_RULES_PATTERN_FLAG = "Refaster:NamePattern";
    private static final long serialVersionUID = 1L;
    private final CodeTransformer codeTransformer;

    public Refaster() {
        this(ErrorProneFlags.empty());
    }

    @Inject
    @VisibleForTesting
    public Refaster(ErrorProneFlags flags) {
        this.codeTransformer = Refaster.createCompositeCodeTransformer(flags);
    }

    @CanIgnoreReturnValue
    public Description matchCompilationUnit(CompilationUnitTree tree, VisitorState state) {
        ArrayList<Description> matches = new ArrayList<Description>();
        this.codeTransformer.apply(state.getPath(), (Context)new SubContext(state.context), matches::add);
        this.applyMatches(matches, ((JCTree.JCCompilationUnit)tree).endPositions, state);
        return Description.NO_MATCH;
    }

    private void applyMatches(Iterable<Description> allMatches, EndPosTable endPositions, VisitorState state) {
        ImmutableList byReplacementSize = ImmutableList.sortedCopyOf(Comparator.comparingInt(d -> Refaster.getReplacedCodeSize(d, endPositions)).reversed().thenComparingInt(d -> Refaster.getInsertedCodeSize(d, endPositions)), allMatches);
        TreeRangeSet replacedSections = TreeRangeSet.create();
        for (Description description : byReplacementSize) {
            ImmutableRangeSet<Integer> ranges = Refaster.getReplacementRanges(description, endPositions);
            if (!ranges.asRanges().stream().noneMatch(arg_0 -> ((RangeSet)replacedSections).intersects(arg_0))) continue;
            state.reportMatch(Refaster.augmentDescription(description, this.getSeverityOverride(state)));
            replacedSections.addAll(ranges);
        }
    }

    private Optional<BugPattern.SeverityLevel> getSeverityOverride(VisitorState state) {
        return Optional.ofNullable((ErrorProneOptions.Severity)state.errorProneOptions().getSeverityMap().get((Object)this.canonicalName())).flatMap(Refaster::toSeverityLevel);
    }

    private static Optional<BugPattern.SeverityLevel> toSeverityLevel(ErrorProneOptions.Severity severity) {
        return switch (severity) {
            case ErrorProneOptions.Severity.DEFAULT -> Optional.empty();
            case ErrorProneOptions.Severity.WARN -> Optional.of(BugPattern.SeverityLevel.WARNING);
            case ErrorProneOptions.Severity.ERROR -> Optional.of(BugPattern.SeverityLevel.ERROR);
            default -> throw new IllegalStateException(String.format("Unsupported severity='%s'", severity));
        };
    }

    private static Description augmentDescription(Description description, Optional<BugPattern.SeverityLevel> severityOverride) {
        return Description.builder((JCDiagnostic.DiagnosticPosition)description.position, (String)"Refaster Rule", (String)description.getLink(), (String)String.join((CharSequence)": ", description.checkName, description.getRawMessage())).overrideSeverity(severityOverride.orElse(description.severity())).addAllFixes((List)description.fixes).build();
    }

    private static int getReplacedCodeSize(Description description, EndPosTable endPositions) {
        return Refaster.getReplacements(description, endPositions).mapToInt(Replacement::length).sum();
    }

    private static int getInsertedCodeSize(Description description, EndPosTable endPositions) {
        return Refaster.getReplacements(description, endPositions).mapToInt(r -> r.replaceWith().length()).sum();
    }

    private static ImmutableRangeSet<Integer> getReplacementRanges(Description description, EndPosTable endPositions) {
        return (ImmutableRangeSet)Refaster.getReplacements(description, endPositions).map(Replacement::range).filter(Predicate.not(Range::isEmpty)).collect(ImmutableRangeSet.toImmutableRangeSet());
    }

    private static Stream<Replacement> getReplacements(Description description, EndPosTable endPositions) {
        return description.fixes.stream().flatMap(fix -> fix.getReplacements(endPositions).stream());
    }

    private static CodeTransformer createCompositeCodeTransformer(ErrorProneFlags flags) {
        ImmutableListMultimap<String, CodeTransformer> allTransformers = CodeTransformers.getAllCodeTransformers();
        return CompositeCodeTransformer.compose((Iterable)((Iterable)flags.get(INCLUDED_RULES_PATTERN_FLAG).map(Pattern::compile).map(nameFilter -> Refaster.filterCodeTransformers(allTransformers, nameFilter)).orElseGet(() -> allTransformers.values())));
    }

    private static ImmutableList<CodeTransformer> filterCodeTransformers(ImmutableListMultimap<String, CodeTransformer> transformers, Pattern nameFilter) {
        return (ImmutableList)transformers.entries().stream().filter(e -> nameFilter.matcher((CharSequence)e.getKey()).matches()).map(Map.Entry::getValue).collect(ImmutableList.toImmutableList());
    }
}

