/*
 * Decompiled with CFR 0.152.
 */
package tech.kwik.agent15.extension;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import tech.kwik.agent15.TlsConstants;
import tech.kwik.agent15.alert.DecodeErrorException;
import tech.kwik.agent15.extension.Extension;

public class SupportedGroupsExtension
extends Extension {
    private final List<TlsConstants.NamedGroup> namedGroups = new ArrayList<TlsConstants.NamedGroup>();

    public SupportedGroupsExtension(TlsConstants.NamedGroup namedGroup) {
        this.namedGroups.add(namedGroup);
    }

    public SupportedGroupsExtension(ByteBuffer buffer) throws DecodeErrorException {
        int extensionDataLength = this.parseExtensionHeader(buffer, TlsConstants.ExtensionType.supported_groups, 4);
        int namedGroupsLength = buffer.getShort();
        if (extensionDataLength != 2 + namedGroupsLength) {
            throw new DecodeErrorException("inconsistent length");
        }
        if (namedGroupsLength % 2 != 0) {
            throw new DecodeErrorException("invalid group length");
        }
        for (int i = 0; i < namedGroupsLength; i += 2) {
            int namedGroupBytes = buffer.getShort() % 65535;
            TlsConstants.decodeNamedGroup(namedGroupBytes).ifPresent(algorithm -> this.namedGroups.add((TlsConstants.NamedGroup)((Object)algorithm)));
        }
    }

    @Override
    public byte[] getBytes() {
        int extensionLength = 2 + this.namedGroups.size() * 2;
        ByteBuffer buffer = ByteBuffer.allocate(4 + extensionLength);
        buffer.putShort(TlsConstants.ExtensionType.supported_groups.value);
        buffer.putShort((short)extensionLength);
        buffer.putShort((short)(this.namedGroups.size() * 2));
        for (TlsConstants.NamedGroup namedGroup : this.namedGroups) {
            buffer.putShort(namedGroup.value);
        }
        return buffer.array();
    }

    public String toString() {
        return "SupportedGroupsExtension" + String.valueOf(this.namedGroups);
    }

    public List<TlsConstants.NamedGroup> getNamedGroups() {
        return this.namedGroups;
    }
}

